% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_gev.R
\name{RegioGEVSeas}
\alias{RegioGEVSeas}
\title{Seasonal regional (or local) parameter and quantile estimation}
\usage{
RegioGEVSeas(x1, x2, p, j = 1, leftrim = 0, rightrim = 0, na.rm = TRUE,
  ...)
}
\arguments{
\item{x1}{vector or matrix of observations from season 1 (rows: observations, columns: stations).}

\item{x2}{vector or matrix of observations from season 2 (rows: observations, columns: stations).}

\item{p}{a probability.}

\item{j}{quantile and parameter estimation for the jth station (jth column of \code{x}).
Irrelevant if is \code{x1} and \code{x2} are vectors.}

\item{leftrim}{integer indicating lower trimming parameter (\eqn{\ge 0}).}

\item{rightrim}{integer indicating upper trimming parameter (\eqn{\ge 0}).}

\item{na.rm}{Should missing values be removed?}

\item{...}{additional arguments, see \link[TLMoments]{TLMoments}.}
}
\value{
List of \itemize{
\item \code{quant} quantile calculation from an estimated two-component GEV with a
regional (or local) shape-parameters.
\item \code{param1} estimated parameter vector from season 1 from a GEV (using L-moments or trimmed L-moments).
\item \code{param2} estimated parameter vector from season 2 from a GEV (using L-moments or trimmed L-moments).}
}
\description{
Calculates regional (or local) parameters of a two-component GEV distribution (product of two GEVs)
using (trimmed) L-moments (see \link[TLMoments]{TLMoments} and \link[TLMoments]{parameters})
from two vectors or two matrices of observation, e.g. winter and summer observations
from one or more than one station.
Based on these two parameter vectors, a p-quantile of the two-component GEV will
be calculated for the jth station.
}
\examples{
library("evd")
# Seasonal observations of 80 years at one station:
x1 <- rgev(80, 2, 1, 0.2) # observations from season 1
x2 <- rgev(80, 3, 1, 0.3) # observations from season 2
RegioGEVSeas(x1=x1, x2=x2, p=0.95)

# Missing values in both seasons in the same year(s):
x1a <- c(NA, x1, NA)
x2a <- c(NA, x2, NA)
RegioGEVSeas(x1a, x2a, p=0.99, leftrim=0, rightrim=0, na.rm=TRUE)

# Missing values in both seasons in different year(s):
x1b <- x1
x1b[c(4,19)] <- NA
x2b <- x2
x2b[77] <- NA
RegioGEVSeas(x1b, x2b, p=0.99, leftrim=0, rightrim=0, na.rm=TRUE)

# Seasonal observations of 100 years at 4 stations:
x1 <- matrix(rgev(400, 2, 1, 0.3), ncol=4)
x2 <- matrix(rgev(400, 4, 1, 0.2), ncol=4)
# estimate quantile for station 1 and 2 (consider the same shape-parameters):
RegioGEVSeas(x1, x2, p=0.99, j=1, leftrim=0, rightrim=0)
RegioGEVSeas(x1, x2, p=0.99, j=2, leftrim=0, rightrim=0)

# With missing values:
x3 <- x1
x4 <- x2
x3[c(54, 89, 300)] <- NA
RegioGEVSeas(x3, x4, p=0.99, j=1, leftrim=0, rightrim=0)
}

