% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_evi.R
\name{RegioHill}
\alias{RegioHill}
\title{Regional EVI estimator}
\usage{
RegioHill(x, k, k.qu = 20, type = "evopt", alpha = 0.05, ci = "nonlog")
}
\arguments{
\item{x}{Vector or matrix of observations}

\item{k}{Number of relative excesses involved in the estimation of the extreme value
index gamma. If \code{k} is missing, it will be set to \itemize{
 \item \eqn{k=\left\lfloor 2n^{2/3}\right\rfloor}{k=floor(2*n^(2/3))}, where n is the
sample length of the vector \code{x} after removing missing values
 \item \eqn{k=\left\lfloor \frac{2n^{2/3}}{d^{1/3}}\right\rfloor}{k=floor(2*n^(2/3)/d^(1/3))}, where d is the number of
 columns of the matrix \code{x} and n the length of each column after removing missing values.}}

\item{k.qu}{Tuning parameter for estimation of empirical variance; only needed if \code{type="opt"}.}

\item{type}{Choose either \code{"evopt"} if extreme value dependent, \code{"ind"} if independent or \code{"opt"} for arbitrarily dependent components.}

\item{alpha}{Confidence level for confidence interval.}

\item{ci}{Either \code{"nonlog"} for standart or \code{"log"} for non-standart confidence interval based on log-transformed hill estimates.}
}
\value{
List of \itemize{
 \item \code{est} a weighted average of local Hill estimates.
 \item \code{Sigma} an estimate of the corresponding variance matrix.
 \item \code{CI} a confidence interval.}
}
\description{
Estimation of the positive extreme value index (EVI) based on multiple local Hill estimators. We assume heavy-tail homogeneity, i.e., all local EVI's are the same.
}
\examples{
library("evd")
x1 <- rgev(150, loc = 2, scale = 1, shape=0.4)
hill(x1, k=20)
x2 <- rgev(100, loc = 2.5, scale = 1, shape=0.4)
x2 <- c(x2, rep(NA, 50))
x <- cbind(x1, x2)
k <- c(40, 30)
RegioHill(x, k)
}

