% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_evi.R
\name{TailAnova}
\alias{TailAnova}
\title{Heavy-tail ANOVA}
\usage{
TailAnova(x, k, k.qu = 20, type = "evopt", cf = TRUE)
}
\arguments{
\item{x}{Matrix of observations}

\item{k}{Number of relative excesses involved in the estimation of the extreme value
index gamma. If \code{k} is missing, it will be set to
\eqn{k=\left\lfloor \frac{2n^{2/3}}{d^{1/3}}\right\rfloor}{k=floor(2*n^(2/3)/d^(1/3))}, where d is the number of
 columns of the matrix \code{x} and n the length of each column after removing missing values.}

\item{k.qu}{Tuning parameter for estimation of empirical variance; only needed if \code{type="opt"}.}

\item{type}{Choose either \code{"evopt"} if extreme value dependent, \code{"ind"} if independent or \code{"opt"} for arbitrarily dependent components.}

\item{cf}{If \code{TRUE}, a correctur factor is used, which improves the size at the cost of power.}
}
\value{
Test statistic and p-value.
}
\description{
A test of heavy-tail homogeneity, that is, equality of the positive extreme value index for all d columns of \code{x}.
}
\examples{
library("evd")
set.seed(6754)
x1 <- rgev(150, loc = 2, scale = 1, shape=0.4)
x2 <- rgev(150, loc = 2.5, scale = 1, shape=0.1) # H_0 violated because of different shapes
x <- cbind(x1, x2)
TailAnova(x)

x1 <- rgev(150, loc = 2, scale = 1, shape=0.3)
x2 <- rgev(150, loc = 2.5, scale = 1, shape=0.3) # H_0 not violated because of same shapes
x <- cbind(x1, x2)
TailAnova(x)
}

