% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_gantt_data.R
\name{bind_gantt_data}
\alias{bind_gantt_data}
\title{Bind gantt chart data}
\usage{
bind_gantt_data(
  .,
  gantt_data = NULL,
  start_date = NULL,
  end_date = NULL,
  task = NULL,
  grouping = NULL,
  color = NULL,
  progress = NULL,
  filter = NULL,
  metadata = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{gantt_data}{Gantt data.}

\item{start_date}{Start date}

\item{end_date}{End date. The end date or time of the event.  If working with days, the end date should be the first day after the end date.  So if your event stretches from 1/1. and ends on the 5/1. your end date should be 6/1.  This will mean your Gantt bar will stretch across the last day of your project or task. Flourish type hint: column}

\item{task}{Task}

\item{grouping}{Group. Select a categorical column to combine bars into groups on the Y axis. Flourish type hint: column}

\item{color}{Color category. Select a categorical column; each unique value in the column will become a color. Flourish type hint: column}

\item{progress}{Progress. Requires a number column with values between 0 and 1, representing the progress from 0 to 100\%. Flourish type hint: column}

\item{filter}{Filter. If set, creates a filter menu or time slider. Flourish type hint: column}

\item{metadata}{Info for popups. One or more columns of information (text, image URLs, embedded charts etc) to include in popups and panelsFlourish type hint: columns}
}
\value{
A Flourish chart
}
\description{
Bind gantt chart data
}
\examples{
try(
  flourish(chart_type = "gantt", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_gantt_data(gapminder)
)
}
