% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_hierarchy_data.R
\name{bind_hierarchy_data}
\alias{bind_hierarchy_data}
\title{Bind hierarchy data}
\usage{
bind_hierarchy_data(
  .,
  data = NULL,
  nest_columns = NULL,
  size_columns = NULL,
  filter = NULL,
  popup_metadata = NULL,
  nest_columns_input_format = NULL,
  nest_columns_output_format = NULL,
  filter_input_format = NULL,
  filter_output_format = NULL,
  popup_metadata_input_format = NULL,
  popup_metadata_output_format = NULL,
  size_columns_input_format = NULL,
  size_columns_output_format = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{nest_columns}{Categories/nesting. Choose one or more categorical columns to nest by. The data is nested in the same order as the chosen columns (e.g. C, B is different from B, C). Suggested data type hints: string. Flourish type hint: columns}

\item{size_columns}{Size by. Optionally choose one or more numeric columns to size by. If more than one is chosen, a dropdown will appear in the visualization which lets the user choose. Rows with negative values are excluded. Suggested data type hints: number. Flourish type hint: columns}

\item{filter}{Filter. Optionally choose a categorical column to filter by. Suggested data type hints: string, number, datetime. Flourish type hint: column}

\item{popup_metadata}{Info for popups. One or more columns of information (text,  image URLs ,  embedded charts  etc) to include in  popups and panels Suggested data type hints: string, number, datetime. Flourish type hint: columns}

\item{nest_columns_input_format}{Formats/parses dates, strings, and numbers for the nest_columns column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{nest_columns_output_format}{Formats/parses dates, strings, and numbers for the nest_columns column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{filter_input_format}{Formats/parses dates, strings, and numbers for the filter column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{filter_output_format}{Formats/parses dates, strings, and numbers for the filter column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{popup_metadata_input_format}{Formats/parses dates, strings, and numbers for the popup_metadata column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{popup_metadata_output_format}{Formats/parses dates, strings, and numbers for the popup_metadata column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{size_columns_input_format}{Formats/parses dates, strings, and numbers for the size_columns column. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{size_columns_output_format}{Formats/parses dates, strings, and numbers for the size_columns column. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}
}
\value{
A Flourish chart
}
\description{
Bind hierarchy data
}
\examples{
try(
  flourish(chart_type = "treemap", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_hierarchy_data(gapminder)
)
}
