% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flourish.R
\name{flourish}
\alias{flourish}
\title{Plot a Flourish graph.}
\usage{
flourish(
  chart_type = NULL,
  chart_description = NULL,
  base_visualisation_id = NULL,
  template_id = NULL,
  template_version_number = NULL,
  api_key = Sys.getenv("FLOURISH_API_KEY")
)
}
\arguments{
\item{chart_type}{Required - a chart type string for each graph in Flourish's library. Preferred usage compared to \code{template_id} and \code{template_version}.}

\item{chart_description}{Optional - a screen-reader description. A text alternative to the visual content that will only be visible to screen-readers, e.g. “The line chart shows China consistently higher than the other countries since 1990”. Do no replicate your title, since that will also be read by screenreaders.}

\item{base_visualisation_id}{Optional - provide the numerical ID of an existing public (published) Flourish visualisation to reference it's configuration}

\item{template_id}{Optional - the Flourish template ID, found at https://app.flourish.studio/@flourish. Use if you cannot use \code{chart_type}.}

\item{template_version_number}{Optional - the template's version number. Also found at https://app.flourish.studio/@flourish. Use if you cannot use \code{chart_type}.}

\item{api_key}{Required - our API key which can be generated within your profile account. Defaults to Sys.getenv("FLOURISH_API_KEY").}
}
\value{
A Flourish chart
}
\description{
Create a graph using Flourish's API (https://developers.flourish.studio/api/introduction/).
}
\examples{
try(
  flourish(
    chart_type = "scatter", api_key = Sys.getenv("FLOURISH_API_KEY")
  ) |> 
  bind_scatter_data(
    data = subset(gapminder, year == 2007), 
    y = "gdpPercap", x = "lifeExp"
  )
 )
}
