% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{fm_collect}
\alias{fm_collect}
\title{Make a collection function space}
\usage{
fm_collect(x, ...)
}
\arguments{
\item{x}{list of function space objects, such as \code{\link[=fm_mesh_2d]{fm_mesh_2d()}}, all of the
same type.}

\item{...}{Currently unused}
}
\value{
A \code{fm_collect} or \code{fm_collect_list} object.
Elements of \code{fm_collect}:
\describe{
\item{fun_spaces}{\code{fm_list} of function space objects}
\item{manifold}{character; manifold type summary, obtained from the
function spaces.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Collection function spaces. The interface and object storage model
is experimental and may change.
}
\examples{
m <- fm_collect(list(
  A = fmexample$mesh,
  B = fmexample$mesh
))
m2 <- fm_as_collect(m)
m3 <- fm_as_collect_list(list(m, m))
c(fm_dof(m$fun_spaces[[1]]) + fm_dof(m$fun_spaces[[2]]), fm_dof(m))
fm_basis(m, loc = tibble::tibble(
  loc = fmexample$loc_sf,
  index = c(1, 1, 2, 2, 1, 2, 2, 1, 1, 2)
), full = TRUE)
fm_basis(m, loc = tibble::tibble(
  loc = rbind(c(0, 0), c(0.1, 0.1)),
  index = c("B", "A")
), full = TRUE)
fm_evaluator(m, loc = tibble::tibble(loc = cbind(0, 0), index = 2))
names(fm_fem(m))
fm_diameter(m)
}
\seealso{
Other object creation and conversion: 
\code{\link{fm_as_collect}()},
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_lattice_Nd}()},
\code{\link{fm_mesh_1d}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_segm}()},
\code{\link{fm_simplify}()},
\code{\link{fm_tensor}()}
}
\concept{object creation and conversion}
