% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{fmpc_get_url}
\alias{fmpc_get_url}
\title{GET Request for specific URL}
\usage{
fmpc_get_url(URL, api_version = "3")
}
\arguments{
\item{URL}{The URL to pull specific data from FMP Cloud. Search parameters
should be included, but not the API key. Start with the URL after 'api/v3'}

\item{api_version}{The API version of the URL. FMP is constantly updating
their API and new URLs may be under anew version}
}
\value{
list output of data set
}
\description{
FMP helper function that takes a URL, appends the API Token, makes a GET
call, and parses the data
}
\details{
This function is a helper in most other fmpcloudr functions, so does not need
to be used by the end user. That being said, FMP is always adding data with
new URLs. If this package does not have a URL available on FMP, this function
can be used to simplify the GET call. Pass the URL appearing after 'api/v3'
with the search parameters entered, but do not include the API token
}
\examples{
\dontrun{
# Set the FMP Token. The DEMO token has VERY limited access.
fmpc_set_token('demo')

# Pull price history for Apple
AppleHist = fmpc_get_url('historical-price-full/AAPL?serietype=line&')
}
}
