\name{plot}
\alias{plot.forecastlpacf}
\title{Plot the results of forecasting using \code{\link{forecastlpacf}}
}
\description{The \code{\link{forecastlpacf}} performs forecasting on
	a locally stationary (wavelet) time series. This function
	provides several options to plot the results in a user-friendly
	fashion.
}
\usage{
\method{plot}{forecastlpacf}(x, extra.y = NULL, f.col = 4, show.pi = "standard", 
    pi.col = 2, xlab = "Time", ylab = "Time Series", zoom = FALSE, zoom.no = 30, 
    sw = 0.2, conf.level = 95, pc.fan = (1:9) * 10, fan.seps = FALSE, 
    fan.rgb.col=c(1,0,0), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{The object returned by the \code{\link{forecastlpacf}} function.
}
  \item{extra.y}{Sometimes other routines wish to add to the plot generated
	by this function. The y-axis extent of those extra values might be
	larger than the values that this plot alone would generate. So,
	you can use this argument to provide a set of y-values that you want
	to later plot and this plot takes those into account when setting
	the scale of the y-axis. So, if you have extra characters or lines
	to plot after this plot, and you want to ensure they'll get plotted
	and that the y-axis is going to be large enough, supply the y values
	as a vector (or just their maximum and minimum) and this function
	will use them to help set the y-axis scale.
}
  \item{f.col}{The colour used to drae the forecasted values - both the points
	and line joining the forecasts.
}
  \item{show.pi}{If set to "standard" then 100*conf.level percent prediction
	intervals are drawn for each forecasted point in the colour specified
	by \code{pi.col}. If set to "none" then no prediction intervals are
	drawn. If set to "fan" then a Bank-of-England-like fan-plot is
	produced with confidence levels set by the \code{pc.fan} argument.
}
  \item{pi.col}{Colour of the prediction intervals or fan plot.
}
  \item{xlab}{The x-axis label.
}
  \item{ylab}{The y-axis label.
}
  \item{zoom}{Sometimes for a long time series with a few forecasts the
	forecast values can be hard to see and particularly how they relate
	to the values of the series near to the end of the series. If
	\code{TRUE} then this argument causes the function to only
	plot the last \code{zoom.no} values of the time series and the
	associated forecasts. One can then focus on the end of the time
	series nearer to the forecast values and those values.
	If \code{FALSE} then the whole time series and the forecasts are
	plotted and \code{zoom.no} is ignored.
}
  \item{zoom.no}{The number of time series values plotted if \code{zoom=TRUE}.
}
  \item{sw}{The width of the prediction intervals if \code{show.pi="standard"}.
}
  \item{conf.level}{A single confidence value associated with the prediction
	interval expressed as a numerical value from 0-100.
}
  \item{pc.fan}{A vector of
	confidence values associated with the fan plot prediction
	intervals expressed as a percentage. 
}
  \item{fan.seps}{If \code{TRUE} then lines are drawn on the fan part of
	the fan plot to more clearly indicated the distinction between
	different prediction intervals. If \code{FALSE} then no extra
	lines are drawn.
}
  \item{fan.rgb.col}{A vector of length three containing the red, green
	and blue intensities of the fan plot colour}
  \item{\dots}{Other arguments to plot.
}
}
\details{This function produces a plot of a time series and its forecasts
	generated by the \code{\link{forecastlpacf}} function.
}
\value{The function only returns information if \code{show.pi="fan"}.
	In this case an array is returned that contained the coordinates
	of the fan part of the plot. The array is three-dimensional.
	Dimension 1 corresponds to the number of steps ahead that we computed
	for the forecast in the object \code{x}, dimension 2 corresponds to
	the number of fan prediction intervals specified by the number of
	confidence bands in \code{pc.fan}, dimension 3 always has two
	dimensions: 1 corresponding to the upper prediction interval and
	2 correspond to the lower interval. For example, element[2, 3, 1]
	corresponds to the upper prediction interval, for the fan component
	associated with the third fan confidence level value in \code{pc.fan}
	for the \code{h=2} step ahead forecast.
}
\references{
Killick, R., Knight, M.I., Nason, G.P., Nunes M.A., Eckley I.A. (2023) Automatic Locally Stationary Time Series Forecasting with
application to predicting U.K. Gross Value Added Time Series under sudden shocks caused by the COVID pandemic 
\href{https://arxiv.org/abs/2303.07772}{arXiv:2303.07772}
}
\author{
Guy Nason
}

\seealso{\code{\link{forecastlpacf}}}

\examples{
#
# Simulate an example
#
x.test <- tvar2sim()
#
# Do a two-step ahead forecast
#
x.fl <- forecastlpacf(x.test, h=2, forecast.type="recursive")
#
# Now plot it.
#
# zoom=TRUE: so we only plot the last 30 time series observations, by default
# 	change zoom.no if you want more or less.
# f.col=3: the forecasts and connecting lines are drawn in colour 3 (blue)
# show.pi="fan": do a fan chart for the forecasts
# fan.rgb.col=c(1,0,1):	draw the fan in magenta (default is red)
# ylab="My Time Series": change the y label to something nice
#
plot(x.fl,zoom=TRUE, f.col=3, show.pi="fan", fan.rgb.col=c(1,0,1), ylab="My Time Series")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ts}
\keyword{hplot}
