% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCW.R
\name{LCW}
\alias{LCW}
\title{Latent Class Weibull (LCW) Model for Projecting Customer Retention}
\usage{
LCW(surv_value, h, lower = c(0.001, 0.001, 0.001, 0.001, 0.001),
  upper = c(0.99999, 10000, 0.999999, 10000, 0.99999))
}
\arguments{
\item{surv_value}{a numeric vector of historical customer retention percentage should start at 100 and non-starting values should be between 0 and less than 100}

\item{h}{forecasting horizon}

\item{lower}{lower limit used in \code{R} \code{optim} rotuine. Default is \code{c(0.001,0.001,0.001,0.001,0.001)}.}

\item{upper}{upper limit used in \code{R} \code{optim} rotuine. Default is \code{c(0.99999,10000,0.999999,10000,0.99999)}.}
}
\value{
\item{fitted:}{Fitted Values based on historical data}
\item{projected:}{Projected \code{h} values based on historical data}
\item{max.likelihood:}{Maximum Likelihood of LCW}
\item{params - t1,t2,c1,c2,w:}{Returns t1,c1,t2,c2,w paramters from maximum likelihood estimation}
}
\description{
\code{LCW} is a latent class weibull model implementation based on \code{Fader and Hardie} probability based projection methedology. The survivor function for \code{LCW} is \deqn{wS(t|t1,c1)+(1-w)S(t|t2,c2), 0<w<1}
}
\examples{
surv_value <- c(100,86.9,74.3,65.3,59.3,55.1,51.7,49.1,46.8,44.5,42.7,40.9,39.4)
h <- 6
LCW(surv_value,h)

}
\references{
{Fader P, Hardie B. How to project customer retention. Journal of Interactive Marketing. 2007;21(1):76-90.}

{Fader P, Hardie B, Liu Y, Davin J, Steenburgh T. "How to Project Customer Retention" Revisited: The Role of Duration Dependence. Journal of Interactive Marketing. 2018;43:1-16.}
}
