% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exltrend.R
\name{exltrend}
\alias{exltrend}
\title{Excel based trendlines for projecting customer retention.}
\usage{
exltrend(surv_value, h)
}
\arguments{
\item{surv_value}{a numeric vector of historical customer retention percentage should start at 100 and non-starting values should be between 0 and less than 100}

\item{h}{forecasting horizon}
}
\value{
\item{fitted:}{A data frame of fitted Values based on historical data for linear (lin.p), exponential (exp.p), logarthmic (log.p), polynomial (poly.p) of order 2 and power (pow.p) trends.}
\item{projected:}{A data frame of projected \code{h} values based on historical data for linear (lin.p), exponential (exp.p), logarthmic (log.p), polynomial (poly.p) of order 2 and power (pow.p) trends.}
}
\description{
\code{exltrend} generates Microsoft(r) Excel(r) based linear, logarthmic, exponential, polynomial of order 2, power trends.
}
\examples{
surv_value <- c(100,86.9,74.3,65.3,59.3)
h <- 6
exltrend(surv_value,h)

}
