% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpaccess.R
\name{Fpsn_w_nomemory}
\alias{Fpsn_w_nomemory}
\title{Fpsn_w_nomemory}
\usage{
Fpsn_w_nomemory(x, w, Kmax, mini = min(x), maxi = max(x))
}
\arguments{
\item{x}{a numerical vector to segment}

\item{w}{a numerical vector of weights (values should be larger than 0).}

\item{Kmax}{max number of segments (segmentations in 1 to Kmax segments are recovered).}

\item{mini}{minimum mean segment value to consider in the optimisation}

\item{maxi}{maximum mean segment value to consider in the optimisation}
}
\value{
return a list with the costs J.est in 1 to Kmax changes.
}
\description{
Function to run the weighted pDPA algorithm (Rigaill 2010 and 2015) without storing the set of last changes. It only return the cost in 1 to Kmax changes. It uses functional pruning and segment neighborhood. It optimizes the weighted L2-loss (\eqn{w_i (x_i - \mu)2}) for 1 to Kmax changes.
}
\examples{
res <- Fpsn_w_nomemory(x=rnorm(10^4), w=rep(1, 10^4), K=100)
}
