% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_item.R
\name{recode_chr}
\alias{recode_chr}
\title{recode_chr}
\usage{
recode_chr(df, col, old_names, new_name, regex = FALSE, negate = FALSE)
}
\arguments{
\item{df}{data frame}

\item{col}{unquoted col}

\item{old_names}{character vector or regular expression}

\item{new_name}{atomic chr string}

\item{regex}{Logical, default F. Specify elements for old_names using a regex?}

\item{negate}{logical, defailt F. If negating the regex, set to T}
}
\value{
df
}
\description{
recode_chr
}
\examples{

# Use a negative regex to rename all species other than "virginica" to "none"

iris \%>\%
   recode_chr(
 col = Species,
 old_names = "vir",
 new_name = "none",
 regex = TRUE,
 negate = TRUE) \%>\%
 dplyr::count(Species)

# Specify old names using a regex

iris \%>\%
   recode_chr(
   col = Species,
   old_names = "set|vir",
   new_name = "other",
   regex = TRUE) \%>\%
   dplyr::count(Species)
}
