% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_known_ratio.R
\name{knownqpcr}
\alias{knownqpcr}
\title{Estimate auxiliary parameters using samples with known allele ratios.}
\usage{
knownqpcr(
  housek0,
  target0,
  housek1,
  target1,
  trueY,
  A = rep(1, length(trueY)),
  XInit = c(meanDNA = -10, targetScale = 0, baseChange = 0, sdMeasure = 1, zeroAmount =
    -5, EPCR = 0),
  method = "BFGS",
  pvalue = 0.05,
  trace = 0,
  report = 10,
  verbose = FALSE
)
}
\arguments{
\item{housek0, target0, housek1, target1}{Measured Cq values. Numeric vectors having the same length as \code{trueY}. Values must not be duplicated (any single Cq measure must not be recycled); if the dataset has missing Cq values, there are two ways. 1) Fill the missing values explicitly with NA and use \code{\link{knownqpcr}()}, or 2) use another function \code{\link{knownqpcr_unpaired}()}, which accepts a `long' format dataset.
\cr
In RED-\eqn{\Delta\Delta}Cq method, \code{housek0} and \code{target0} corresponds to the intact test samples (not digested with endonuclease) amplified with the housekeeping- and target-loci, respectively. In general \eqn{\Delta\Delta}Cq analyses, \code{housek0} and \code{target0} are absent, and only test samples (\code{housek1} and \code{target1}) are input by the user. At a first glance, the test samples seem to be unaffected by endonuclease when \code{trueY[i] == 1}, but they must also be input as \code{housek1} or \code{target1} because in fact their Cq values are affected by \code{baseChange}.}

\item{trueY}{A numeric vector having the same length as the Cq data. \code{trueY[i]} signifies the exact allele frequency in the \emph{i}th sample. The values must be between 0 and 1, and \code{NA} is not allowed. To improve the estimation accuracy, it is better to include the settings y == 0 (pure S solution) and y == 1 (pure R) in your dataset.}

\item{A}{Optionally, you can specify relative DNA content between the samples, as a numeric vector having the same length as the Cq data. If present, \code{A} must not include missing values. It is the counterpart of the \code{N} argument in \code{\link{freqpcr}()}, whereas an element of \code{A} is not restricted to integer. Because the concentration as a whole is also adjusted with the parameter \code{meanDNA} (see Value section), \code{A} is used exclusively to reflect the relative contents between the sample solutions. Otherwise, \code{A} should be left unspecified (the default is 1 for all replicates).}

\item{XInit}{Optionally, the named vector specifies the initial parameter values to be optimized. Defined in the natural log scale; e.g. \code{zeroAmount = -5} corresponds to the residue rate \code{exp(-5)} = 0.007. Keeping the default is highly recommended.}

\item{method}{A string specifying the optimization algorithm used in \code{\link[stats]{optim}()}. The default is \code{BFGS}, which is plausible in most situation.}

\item{pvalue}{The two-sided confidence interval is calculated at the last iteration at given significance level. Default is 0.05, which returns the 95\% Wald's CI (2.5 to 97.5 percentile) based on the Hessian matrix.}

\item{trace}{Non-negative integer. If positive, \code{\link[stats]{optim}()} outputs trace information. The default is 0 (no information).}

\item{report}{The frequency of reports if \code{trace} is positive. Defaults to every 10 iterations.}

\item{verbose}{Send messages to stdout? Default is FALSE.}
}
\value{
A table containing the estimated values for the following parameters:
\enumerate{
    \item\code{meanDNA} is the template DNA concentration (of housekeeping gene, per unit volume of sample solution) compared to the threshold line of PCR.
    \item\code{targetScale} (\eqn{\delta_{T}}) is the relative template DNA amount of the target to the houskeeping loci.
    \item\code{baseChange} (\eqn{\delta_{B}}) is the change rate in the DNA amount after endonuclease digestion in RED-\eqn{\Delta\Delta}Cq method. In general \eqn{\Delta\Delta}Cq analyses (neither \code{housek0} nor \code{target0} is input), this parameter is not returned. In both cases, \code{baseChange} is not required to run \code{\link{freqpcr}()}.
    \item\code{sdMeasure} (\eqn{\sigma_{c}}) is the measurement error (standard deviation) at each Cq value.
    \item\code{zeroAmount} (\eqn{z}) is the ratio of non-target allele amplified in qPCR (see the argument list of \code{\link{freqpcr}()}).
    \item\code{EPCR} (\eqn{\eta}) is the amplification efficiency per PCR cycle.
}
}
\description{
The function to estimate the auxiliary experimental parameters using DNA solutions, provided the dataset contains samples with multiple allele mixing ratios and the exact mixing ratio are known for each sample. This function is used when all replicates in the  dataset comprise the complete observations on the \eqn{2 \times 2} combinations of the qPCR conditions in a RED-\eqn{\Delta\Delta}Cq analysis: (loci for target or housekeeping genes) and (the target gene is undigested or digested with endonuclease). The quartet of the four Cq data, \code{housek0}, \code{target0} (these two are undigested samples amplified with housekeeping and target genes, respectively), \code{housek1}, and \code{target1} (digested samples) should be prepared as four numeric vectors having the same length.
\cr
One more variable, \code{trueY} is needed to run the estimation process; it a numeric vector having the same length with the four Cq data. It holds the exact allele-mixing ratio for each quartet (also see the code example). Optionally, you can adjust the relative DNA concentration between the replicates with a parameter vector \code{A}.
\cr
Since version 0.3.2, the \code{\link{knownqpcr}()} function can also deal with general \eqn{\Delta\Delta}Cq analyses. In such cases, samples with any mixing ratios are generally marked as `digested samples' i.e., either of  \code{housek1} or \code{target1}, depending on the loci to be amplified. The arguments of the corresponding undigested samples, \code{housek0} and \code{target0}, must not be specified by the user. Then, the parameter \code{baseChange} (\eqn{\delta_{B}}: the change rate of DNA contents before/after the endonuclease digestion) is not included in the estimation result.
}
\examples{
# A dummy Cq dataset: four mixing ratios with four replicates.
# K:2, scaleDNA:1e-11, targetScale:1.5, baseChange:0.3, zeroAmount:1e-3,
# sdMeasure:0.3, and EPCR:0.95. Assuming a RED-DeltaDeltaCq analyses.
trueY <- c(rep(0.1, 4), rep(0.25, 4), rep(0.5, 4), rep(1, 4))
housek0 <- c( 19.39, 19.78, 19.28, 19.58,  18.95, 19.91, 19.66, 19.96,
              20.05, 19.86, 19.55, 19.61,  19.86, 19.27, 19.59, 20.21 )
target0 <- c( 19.16, 19.08, 19.28, 19.03,  19.17, 19.67, 18.68, 19.52,
              18.92, 18.79, 18.8, 19.28,   19.57, 19.21, 19.05, 19.15 )
housek1 <- c( 21.61, 21.78, 21.25, 21.07,  22.04, 21.45, 20.72, 21.6,
              21.51, 21.27, 21.08, 21.7,   21.44, 21.46, 21.5, 21.8 )
target1 <- c( 24.3, 24.22, 24.13, 24.13,   22.74, 23.14, 23.02, 23.14,
              21.65, 22.62, 22.28, 21.65,  20.83, 20.82, 20.76, 21.3 )
d.cmp <- data.frame(A=rep(1, 16), trueY, housek0, target0, housek1, target1)
print(d.cmp)

# In RED-DeltaDeltaCq analyses, four observations stem from one sample solution.
# Each argument must be specified with its name (name=source).
knownqpcr(  housek0=d.cmp$housek0, target0=d.cmp$target0,
            housek1=d.cmp$housek1, target1=d.cmp$target1,
            trueY=d.cmp$trueY, A=d.cmp$A, verbose=FALSE  )

# In general DeltaDeltaCq analyses, the experimental design will not include
# dedicated control samples. The function then runs without 'housek0' and 'target0'.
knownqpcr(  housek1=d.cmp$housek1, target1=d.cmp$target1,
            trueY=d.cmp$trueY, A=d.cmp$A, verbose=TRUE  )
}
\seealso{
Other estimation procedures: 
\code{\link{freqpcr}()},
\code{\link{knownqpcr_unpaired}()},
\code{\link{sim_dummy}()}
}
\concept{estimation procedures}
