% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_tsplot.R
\name{fsl_tsplot}
\alias{fsl_tsplot}
\alias{fsl_tsplot.help}
\title{FSL Timeseries Plot using `fsl_tsplot` (not `tsplot`)}
\usage{
fsl_tsplot(
  infile,
  outfile = tempfile(fileext = ".png"),
  plot_title = NULL,
  legend = NULL,
  labels = NULL,
  ymin = NULL,
  ymax = NULL,
  xlabel = NULL,
  ylabel = NULL,
  height = NULL,
  width = NULL,
  precision = NULL,
  unit = NULL,
  scientific_notation = FALSE,
  start_position = NULL,
  end_position = NULL,
  ...
)

fsl_tsplot.help()
}
\arguments{
\item{infile}{comma-separated list of input file names 
(ASCII text matrix, one column per timecourse)}

\item{outfile}{output filename for the PNG file}

\item{plot_title}{plot title}

\item{legend}{file name of ASCII text file, one row per legend entry}

\item{labels}{comma-separated list of labels}

\item{ymin}{minimum y-value}

\item{ymax}{maximum y-value}

\item{xlabel}{X-axis label}

\item{ylabel}{Y-axis label}

\item{height}{plot height in pixels (default 150)}

\item{width}{plot width in pixels (default 600)}

\item{precision}{precision of x-axis labels}

\item{unit}{scaling units for x-axis (default 1...length of infile)}

\item{scientific_notation}{switch on scientific notation}

\item{start_position}{Position of first column to plot}

\item{end_position}{Position of final column to plot}

\item{...}{additional options to pass to \code{\link{fslcmd}}}
}
\value{
Name of PNG file
}
\description{
FSL Timeseries Plot using `fsl_tsplot` (not `tsplot`)
}
