% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_linear_dependent_columns.R
\name{find_linear_dependent_columns}
\alias{find_linear_dependent_columns}
\title{Find linear dependent columns in a design matrix}
\usage{
find_linear_dependent_columns(mat, tol = 1e-12)
}
\arguments{
\item{mat}{a matrix}

\item{tol}{a double that specifies the numeric tolerance}
}
\value{
a list with vectors containing the indices of linearly dependent columns
}
\description{
Find linear dependent columns in a design matrix
}
\examples{
  mat <- matrix(rnorm(3 * 10), nrow = 10, ncol = 3)
  mat <- cbind(mat, mat[,1] + 0.5 * mat[,3])
  find_linear_dependent_columns(mat)  # returns list(c(1,3,4))

}
\seealso{
The algorithm and function is inspired by the \code{internalEnumLC}
function in the 'caret' package (\href{https://github.com/topepo/caret/blob/679eabaac7e54f4e87efa6c3bff75659cb457d8b/pkg/caret/R/findLinearCombos.R#L33}{GitHub})
}
