% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_candidate_motifs_plot.R
\name{cluster_candidate_motifs_plot}
\alias{cluster_candidate_motifs_plot}
\title{cluster_candidate_motifs_plot}
\usage{
cluster_candidate_motifs_plot(
  cluster_candidate_motifs_results,
  ylab = "",
  R_all = cluster_candidate_motifs_results$R_all,
  R_m = NULL,
  ask = TRUE
)
}
\arguments{
\item{cluster_candidate_motifs_results}{A list containing the output of the
`cluster_candidate_motifs` function, which includes clustering results and
distances between motifs and curves.}

\item{ylab}{A character string specifying the label for the y-axis in the
plots. Default is an empty string.}

\item{R_all}{A numeric value representing the global radius. This is used
to cut the dendrogram, requiring groups to be more than twice `R_all`
apart. The default is set to the `R_all` component of the input results.}

\item{R_m}{A numeric vector with group-specific radii. The length of this
vector must match the number of clusters obtained by cutting the dendrogram
at height `2 * R_all`. If set to NULL, the radius `R_m` is determined
within each group based on the distances between motifs of the same group
and all curves.}

\item{ask}{A logical value indicating whether the user should be prompted
before a new plot is drawn. Default is TRUE.}
}
\description{
This function generates plots to visualize the results of the
`cluster_candidate_motifs` function. It provides insights into the
distances between motifs and curves, group-specific radii, and displays
aligned motifs for each cluster.
}
\details{
This function produces:
- Histograms of distances between all motifs and all curves, highlighting
the global radius.
- A dendrogram of motifs cut at `2 * R_all`, which allows visualization of
the clustering structure.
- Histograms of distances for motifs within specific clusters, comparing
motifs from curves with and without the motifs.
- Plots of aligned motifs for each cluster, showing their positions and
distributions.
- A scatter plot displaying the approximate average distance against the
approximate frequency for motifs in each cluster.
}
\author{
Marzia Angela Cremona & Francesca Chiaromonte
}
