% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_utilities.R
\name{.generate_coefficients}
\alias{.generate_coefficients}
\title{Generate Coefficients}
\usage{
.generate_coefficients(
  motif_i,
  distrib,
  dist_knots,
  norder,
  coeff_min,
  coeff_max
)
}
\arguments{
\item{motif_i}{A list representing the motif structure that includes the length (`len`).}

\item{distrib}{A string or numeric vector indicating the distribution from which to generate coefficients. 
Accepted values are "unif", "beta", or a numeric vector.}

\item{dist_knots}{A numeric value indicating the distance between knots.}

\item{norder}{An integer specifying the order of the B-spline.}

\item{coeff_min}{A numeric value indicating the minimum coefficient value for uniform or beta distributions.}

\item{coeff_max}{A numeric value indicating the maximum coefficient value for uniform or beta distributions.}
}
\value{
A modified motif structure containing the generated coefficients.
}
\description{
This function generates a vector of coefficients for a motif based on the specified distribution. 
It can sample coefficients from a numeric vector, a uniform distribution, or a beta distribution.
}
\details{
Generate Coefficients for Motif


- For uniform distribution, coefficients are generated within the specified range defined by `coeff_min` and `coeff_max`.
- For beta distribution, coefficients are scaled to the desired range using the specified minimum and maximum values.
}
