% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRTM.R
\name{par.FDTW}
\alias{par.FDTW}
\title{Setting open-end/open-begin functional dynamic time warping (OEB-FDTW) defaults}
\usage{
par.FDTW(
  N = 100,
  M = 50,
  smin = NULL,
  smax = NULL,
  alpha_vec = c(0, 0.5, 1),
  frac_oeob = 0.1,
  eta = 0.5,
  iter = 3,
  template = "Procrustes",
  grid_tem = NULL,
  index_tem = NULL,
  iter_tem = 2,
  lambda = c(0, 10^seq(-8, -2, by = 0.25), 10^5),
  threshold = 0.01,
  seq_t = seq(0.01, 1, length.out = 100)
)
}
\arguments{
\item{N}{The number \eqn{N_{t}} of evenly spaced values along the template domain \eqn{\mathcal{D}_{Y}}.}

\item{M}{The number \eqn{M_{x}} of evenly spaced values along the functional observation domain \eqn{\mathcal{D}_{X_i}}.}

\item{smin}{The minimum  values allowed for the first derivative of the warping function \eqn{h_i}. If NULL, in \code{FRTM_PhaseI}, it is set as  0.001 multiplied by the ratio between the  size
of the monitoring and template domains.}

\item{smax}{The maximum  values allowed for the first derivative of the warping function \eqn{h_i}. If NULL, in \code{FRTM_PhaseI}, it is set as  100 multiplied by the ratio between the  size
of the monitoring and template domains.}

\item{alpha_vec}{Grid of values to find the optimal value of \eqn{\alpha_i}.}

\item{frac_oeob}{Fraction of \eqn{\mathcal{D}_{Y}} and \eqn{\mathcal{D}_{X_i}} to obtain \eqn{\delta_{t,s}}, \eqn{\delta_{t,e}},\eqn{\delta_{x,s}} and \eqn{\delta_{x,e}}.}

\item{eta}{Fraction \eqn{\eta} for updating the constraint bounds  to reduce the error associated to the discretization (Deriso and Boyd, 2022).}

\item{iter}{Number of iteration in the  iterative refinement to reduce the error associated to the discretization (Deriso and Boyd, 2022).}

\item{template}{If "Procrustes", the Procrustes fitting process is used to select the template function. If \code{numeric}, the discrete observations of the template function.}

\item{grid_tem}{If \code{template} is \code{numeric}, a vector of time points where the discrete observations of the template function are sampled.}

\item{index_tem}{If NULL and \code{template="Procrustes"}, the function in the training set, whose domain length is nearest the median domain length, is chosen as initial estimate of the template function.
If an \code{integer}  and \code{template="Procrustes"}, the  \code{index_tem} function in the training set is chosen as initial estimate of the template function.
If \code{template} is \code{numeric}, this parameter is not used.}

\item{iter_tem}{Number of iterations in the Procrustes fitting process.}

\item{lambda}{Grid of smoothing parameters to evaluate the average curve distance (ACD).}

\item{threshold}{The fraction \eqn{\delta} of the difference between the maximum and the minimum distance in the selection of the smoothing parameter via the ACD.}

\item{seq_t}{Discretized sequence in the template domain \eqn{\mathcal{D}_{Y}}.}
}
\description{
This is an internal function of package \code{FRTM} which allows controlling the parameters to implement the OEB-FDTW in the FRTM method.
}
\examples{
library(funcharts)
par.FDTW()
}
\references{
Deriso, D. and S. Boyd (2022).
A general optimization framework for dynamic time warping.
\emph{Optimization and Engineering, 1-22}.
}
\seealso{
\code{\link{FRTM_PhaseI}}
}
