% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaylorRussell.R
\name{TaylorRussell}
\alias{TaylorRussell}
\title{A generalized (multiple predictor) Taylor-Russell function.}
\usage{
TaylorRussell(SR = NULL, BR = NULL, R = NULL, PrintLevel = 0, Digits = 3)
}
\arguments{
\item{SR}{(vector)  A vector of Selection Ratios for N selection tests.}

\item{BR}{(scalar)  The Base Rate of criterion performance.}

\item{R}{(matrix)  An (N + 1) x (N + 1) correlation matrix in which the 
predictor/criterion correlations are in column  N + 1 of R.}

\item{PrintLevel}{(integer). If \code{PrintLevel = 0} then no output is 
printed to screen. If \code{PrintLevel > 0} then output is printed to screen. 
Defaults to \code{PrintLevel = 0}.}

\item{Digits}{(integer)  The number of significant digits in the printed 
output.}
}
\value{
The following output variables are returned.

\itemize{
  \item \strong{BR}: (scalar) The Base Rate of criterion performance. 
  \item \strong{SR}: (vector) The user-defined vector of predictor Selection 
  Ratios.
  \item \strong{R}: (matrix) The input correlation matrix.  
  \item \strong{TP}: (scalar) The percentage of True Positives.
  \item \strong{FP}: (scalar) The percentage of False Positives.
  \item \strong{TN}: (scalar) The percentage of True Negatives.
  \item \strong{FN}: (scalar) The percentage of False Negatives.
  \item \strong{Accepted}: The percentage of selected individuals 
  (i.e., TP + FP).
  \item \strong{PPV}: The Positive Predictive Value. This is the probability 
  that a selected individual is a True Positive.
  \item \strong{Sensitivity}: The test battery Sensitivity rate.  This is the 
  probability that a person who is acceptable on the criterion is called  
  acceptable by the test battery.
  \item \strong{Specificity}: The test battery Specificity rate.  This is the 
  probability that a person who falls below the criterion threshold 
  is deemed unacceptable by the test battery.
}
}
\description{
Generalized Taylor-Russell Function for Multiple Predictors
}
\examples{
# Example 1
# Reproduce Table 3 (p. 574) of Taylor and Russell

r <- seq(0, 1, by = .05)
sr <- c(.05, seq(.10, .90, by = .10), .95)
num.r <- length(r)
num.sr <- length(sr)

old <- options(width = 132)

Table3 <- matrix(0, num.r, num.sr)
for(i in 1 : num.r){
   for(j in 1:num.sr){
   
     Table3[i,j] <-  TaylorRussell(
                       SR = sr[j],
                       BR = .20, 
                       R = matrix(c(1, r[i], r[i], 1), 2, 2), 
                       PrintLevel = 0,
                       Digits = 3)$PPV  
   
  }# END over j
}# END over i

rownames(Table3) <- r
colnames(Table3) <- sr
Table3 |> round(2)

# Example 2
# Thomas, Owen, & Gunst (1977) -- Example 1: Criterion = GPA

R <- matrix(c(1, .5, .7,
             .5, 1, .7,
            .7, .7, 1), 3, 3)

 # See Table 6: Target Acceptance = 20\%
 out.20 <- TaylorRussell(
 SR = c(.354, .354),  # the marginal probabilities
 BR = .60, 
 R = R,
 PrintLevel = 1) 

# See Table 6:  Target Acceptance = 50\%
out.50 <- TaylorRussell(
 SR = c(.653, .653),   # the marginal probabilities
 BR = .60, 
 R = R,
 PrintLevel = 1) 
 
 options(old)
 
}
\references{
\itemize{
  \item Taylor, H. C. & Russell, J. (1939). The relationship of validity 
  coefficients to the practical effectiveness of tests in selection: 
  Discussion and tables. Journal of Applied Psychology, 23(5), 565--578.
  
  \item Thomas, J. G., Owen, D., & Gunst, R. (1977). Improving the use 
  of educational tests as selection tools. Journal of Educational 
  Statistics, 2(1), 55--77. 
}
}
\author{
\itemize{
  \item Niels G. Waller (nwaller@umn.edu)
}
}
\keyword{stats}
