% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faEKC.R
\name{faEKC}
\alias{faEKC}
\title{Calculate Reference Eigenvalues for the Empirical Kaiser Criterion}
\usage{
faEKC(R = NULL, NSubj = NULL, Plot = FALSE)
}
\arguments{
\item{R}{Input correlation matrix.}

\item{NSubj}{Number of subjects (observations) used to create R.}

\item{Plot}{(logical). If \code{Plot = TRUE} the function will plot
the observed and reference eigenvalues of R.}
}
\value{
\itemize{
 \item{ljEKC}, 
 \item{ljEKC1},
 \item{dimensions} The estimated number of common factors.
 }
}
\description{
Calculate Reference Eigenvalues for the Empirical Kaiser Criterion
}
\examples{

data(AmzBoxes)
AmzBox20<- GenerateBoxData(XYZ = AmzBoxes[,2:4], 
                           BoxStudy = 20)$BoxData
RAmzBox20 <- cor(AmzBox20)
EKCout  <- faEKC(R = RAmzBox20, 
                NSubj = 98,
                Plot = TRUE)


}
\references{
Braeken, J. & Van Assen, M. A.  (2017).  An empirical Kaiser criterion. 
\emph{Psychological Methods, 22}(3), 450-466.
}
\seealso{
Other Factor Analysis Routines: 
\code{\link{BiFAD}()},
\code{\link{Box26}},
\code{\link{GenerateBoxData}()},
\code{\link{Ledermann}()},
\code{\link{SLi}()},
\code{\link{SchmidLeiman}()},
\code{\link{faAlign}()},
\code{\link{faIB}()},
\code{\link{faLocalMin}()},
\code{\link{faMB}()},
\code{\link{faMain}()},
\code{\link{faScores}()},
\code{\link{faSort}()},
\code{\link{faStandardize}()},
\code{\link{faX}()},
\code{\link{fals}()},
\code{\link{fapa}()},
\code{\link{fareg}()},
\code{\link{fsIndeterminacy}()},
\code{\link{orderFactors}()},
\code{\link{print.faMB}()},
\code{\link{print.faMain}()},
\code{\link{promaxQ}()},
\code{\link{summary.faMB}()},
\code{\link{summary.faMain}()}
}
\author{
Niels Waller
}
\concept{Factor Analysis Routines}
\keyword{Statistics}
