% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fundata.R
\name{fundata}
\alias{fundata}
\title{Compute Control Limits for Proportion Data}
\usage{
fundata(input, benchmark, alpha = 0.95, alpha2 = 0.998,
  method = "approximate", step = 0.5)
}
\arguments{
\item{input}{A data frame of your sample data, in the format outlined above.}

\item{benchmark}{A number between 0 and 1 representing the benchmark (e.g. null) estimate for which confidence limits are calculated for. If not specified, the overall proportion of events is used.}

\item{alpha}{A number between 0 and 1 representing the desired confidence limit (e.g. 0.95)}

\item{alpha2}{A number between 0 and 1 representing the desired confidence limit (e.g. 0.998)}

\item{method}{Choose between approximate or exact binomial control limits.}

\item{step}{Minor ticks between 1 and the maximum denominator size of the raw data for which the control limits are calculated for. Must be integer for method=exact.}
}
\description{
This function will return a single data frame consisting of two sets of control limits, which can then be overlaid in a funnel plot.
The incoming data frame (input) should have one observation per row. It must have a column labeled 'n' which represents the number of events (numerator) and a column labeled 'd' which represents the total (denominator).
Other by variables are permitted (e.g. sex, or age).
}
\examples{
#My sample data
my_data  <- data.frame(id=c('A','B','C','D','E'), n=c(2,5,10,15,18), d=c(20,20,20,20,20))

#Compute approximate control limits
my_fpdata <- fundata(my_data, alpha=0.95, alpha2=0.998, method='approximate', step=0.5)
}
