% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionDiv.R
\name{fusionDiv}
\alias{fusionDiv}
\title{Adding FusionCharts Div & Grid}
\usage{
fusionDiv(
  fusionPlot,
  adjustDiv = FALSE,
  numDivLines = "5",
  divLineColor = "#5a5a5a",
  divLineAlpha = "10",
  divLineDashed = FALSE,
  divLineDashLen = "5",
  divLineDashGap = "6",
  numVDivLines = "5",
  vDivLineColor = "#F2F2F2",
  vDivLineThickness = "1",
  vDivLineAlpha = "100",
  vDivLineDashed = FALSE,
  vDivLineDashLen = "5",
  vDivLineDashGap = "3",
  showAlternateHGridColor = FALSE,
  alternateHGridColor = "#5a5a5a",
  alternateHGridAlpha = "1",
  showAlternateVGridColor = FALSE,
  alternateVGridColor = "#5a5a5a",
  alternateVGridAlpha = "3"
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{adjustDiv}{Enable the automatic adjustment of horizontal lines}

\item{numDivLines}{Set the number of hozitontal lines}

\item{divLineColor}{Specify the hex code for the color of the hozitontal lines}

\item{divLineAlpha}{Set the transparency of the horizontal lines}

\item{divLineDashed}{Display the hozitontal lines as dashed}

\item{divLineDashLen}{Set the length of each dashed hozitontal lines}

\item{divLineDashGap}{Set the gap between the dashed hozitontal lines}

\item{numVDivLines}{Specify the number of vertical lines}

\item{vDivLineColor}{Set the color of the vertical lines}

\item{vDivLineThickness}{Set the thickness of the vertical lines}

\item{vDivLineAlpha}{Set the transparency of the vertical lines}

\item{vDivLineDashed}{Display the vertical lines as dashed}

\item{vDivLineDashLen}{Set the length of each dashed vertical lines}

\item{vDivLineDashGap}{Set the gap between the dashed vertical lines}

\item{showAlternateHGridColor}{Display the horizontal grid bands}

\item{alternateHGridColor}{Specify the hex code for the color of the horizontal grid}

\item{alternateHGridAlpha}{Set the transparency of the horizontal grid}

\item{showAlternateVGridColor}{Display the vertical grid bands}

\item{alternateVGridColor}{Specify the hex code for the color of the vertical grid}

\item{alternateVGridAlpha}{Set the transparency of the vertical grid}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/div-lines-and-grids} &
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/vertical-div-lines}
}
\examples{
library(fusionchartsR)
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260, 180, 115))
df \%>\%
  fusionPlot(x = "label", y = "value", type = "column2d") \%>\%
  fusionDiv(divLineColor = "#6699cc", divLineAlpha = "60", divLineDashed = TRUE) \%>\%
  fusionTheme(theme = "fusion")

}
