% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protected_api-resolve.R
\name{resolve}
\alias{resolve}
\title{Resolve one or more futures synchronously}
\usage{
resolve(
  x,
  idxs = NULL,
  recursive = 0,
  result = FALSE,
  stdout = FALSE,
  signal = FALSE,
  force = FALSE,
  sleep = getOption("future.wait.interval", 0.01),
  ...
)
}
\arguments{
\item{x}{A \link{Future} to be resolved, or a list, an environment, or a
list environment of futures to be resolved.}

\item{idxs}{(optional) integer or logical index specifying the subset of
elements to check.}

\item{recursive}{A non-negative number specifying how deep of a recursion
should be done.  If TRUE, an infinite recursion is used.  If FALSE or zero,
no recursion is performed.}

\item{result}{(internal) If TRUE, the results are \emph{retrieved}, otherwise not.
Note that this only collects the results from the parallel worker, which
can help lower the overall latency if there are multiple concurrent futures.
This does \emph{not} return the collected results.}

\item{stdout}{(internal) If TRUE, captured standard output is relayed, otherwise not.}

\item{signal}{(internal) If TRUE, captured \link[base]{conditions} are relayed,
otherwise not.}

\item{force}{(internal) If TRUE, captured standard output and captured
\link[base]{conditions} already relayed are relayed again, otherwise not.}

\item{sleep}{Number of seconds to wait before checking if futures have been
resolved since last time.}

\item{\ldots}{Not used.}
}
\value{
Returns \code{x} (regardless of subsetting or not).
If \code{signal} is TRUE and one of the futures produces an error, then
that error is produced.
}
\description{
This function provides an efficient mechanism for waiting for multiple
futures in a container (e.g. list or environment) to be resolved while in
the meanwhile retrieving values of already resolved futures.
}
\details{
This function is resolves synchronously, i.e. it blocks until \code{x} and
any containing futures are resolved.
}
\seealso{
To resolve a future \emph{variable}, first retrieve its
\link{Future} object using \code{\link[=futureOf]{futureOf()}}, e.g.
\code{resolve(futureOf(x))}.
}
