% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify_uncertainty.R
\name{bootstrap.gain}
\alias{bootstrap.gain}
\title{Construct a Confidence Interval of the Gain Estimate}
\usage{
bootstrap.gain(df1, df2, df3, opt.cov, n.rep, p1.beg, p1.end, p2.beg,
  p2.end, ratedPW, AEP, pw.freq, freq.id = 3,
  time.format = "\%Y-\%m-\%d \%H:\%M:\%S", k.fold = 5, col.time = 1,
  col.turb = 2, free.sec = NULL, neg.power = FALSE,
  pred.return = FALSE)
}
\arguments{
\item{df1}{A dataframe for reference turbine data. This dataframe must
include five columns: timestamp, turbine id, wind direction, power output,
and air density.}

\item{df2}{A dataframe for baseline control turbine data. This dataframe must
include four columns: timestamp, turbine id, wind speed, and power output.}

\item{df3}{A dataframe for neutral control turbine data. This dataframe must
include four columns and have the same structure with \code{df2}.}

\item{opt.cov}{A character vector indicating the optimal set of variables
(obtained from the period 1 analysis).}

\item{n.rep}{An integer describing the total number of replications when
applying bootstrap. This number determines the confidence level; for
example, if \code{n.rep} is set to 10, this function will provide an 80\%
confidence interval.}

\item{p1.beg}{A string specifying the beginning date of period 1. By default,
the value needs to be specified in \samp{\%Y-\%m-\%d} format, for example,
\code{'2014-10-24'}. A user can use a different format as long as it is
consistent with the format defined in \code{time.format} below.}

\item{p1.end}{A string specifying the end date of period 1. For example, if
the value is \code{'2015-10-24'}, data observed until
\code{'2015-10-23 23:50:00'} would be considered for period 1.}

\item{p2.beg}{A string specifying the beginning date of period 2.}

\item{p2.end}{A string specifying the end date of period 2. Defined similarly
as \code{p1.end}.}

\item{ratedPW}{A kW value that describes the (common) rated power of the
selected turbines (REF and CTR-b).}

\item{AEP}{A kWh value describing the annual energy production from a single
turbine.}

\item{pw.freq}{A matrix or a dataframe that includes power output bins and
corresponding frequency in terms of the accumulated hours during an annual
period.}

\item{freq.id}{An integer indicating the column number of \code{pw.freq} that
describes the frequency of power bins in terms of the accumulated hours
during an annual period. By default, this parameter is set to 3.}

\item{time.format}{A string describing the format of time stamps used in the
data to be analyzed. The default value is \code{'\%Y-\%m-\%d \%H:\%M:\%S'}.}

\item{k.fold}{An integer defining the number of data folds for the period 1
analysis and prediction. In the period 1 analysis, \eqn{k}-fold cross
validation (CV) will be applied to choose the optimal set of covariates
that results in the least prediction error. The value of \code{k.fold}
corresponds to the \eqn{k} of the \eqn{k}-fold CV. The default value is 5.}

\item{col.time}{An integer specifying the column number of time stamps in
wind turbine datasets. The default value is 1.}

\item{col.turb}{An integer specifying the column number of turbines' id in
wind turbine datasets. The default value is 2.}

\item{free.sec}{A list of vectors defining free sectors. Each vector in the
list has two scalars: one for starting direction and another for ending
direction, ordered clockwise. For example, a vector of \code{c(310 , 50)}
is a valid component of the list. By default, this is set to \code{NULL}.}

\item{neg.power}{Either \code{TRUE} or \code{FALSE}, indicating whether or
not to use data points with a negative power output, respectively, in the
analysis. The default value is \code{FALSE}, i.e., negative power output
data will be eliminated.}

\item{pred.return}{A logical value whether to return the full prediction
results; see \bold{Details} below. The default value is \code{FALSE}.}
}
\value{
The function returns a list of \code{n.rep} replication objects
  (lists) each of which includes the following. \describe{
  \item{\code{gain.res}}{A list containing gain quantification results; see
  \code{\link{quantify.gain}} for the details.} \item{\code{p1.pred}}{A list
  containing period 1 prediction results. \itemize{ \item{\code{pred.REF}: A
  list of \eqn{k} datasets each representing the \eqn{k}th fold's period 1
  prediction for the REF turbine.} \item{\code{pred.CTR}: A list of \eqn{k}
  datasets each representing the \eqn{k}th fold's period 1 prediction for the
  CTR-b turbine.}}} \item{\code{p2.pred}}{A list containing period 2
  prediction results; see \code{\link{analyze.p2}} for the details.} }
}
\description{
Estimates gain and its confidence interval at a given level of confidence by
using bootstrap.
}
\details{
For each replication, this function will make a \eqn{k} of period 1
  predictions for each of REF and CTR-b turbine models and an additional
  period 2 prediction for each model. This results in \eqn{2 \times (k + 1)}
  predictions for each replication. With \code{n.rep} replications, there
  will be \eqn{n.rep \times 2 \times (k + 1)} predictions in total.

  One can avoid storing such many datasets in the memory by setting
  \code{pred.return} to \code{FALSE}; which is the default setting.
}
\examples{
df.ref <- with(wtg, data.frame(time = time, turb.id = 1, wind.dir = D,
 power = y, air.dens = rho))
df.ctrb <- with(wtg, data.frame(time = time, turb.id = 2, wind.spd = V,
 power = y))
df.ctrn <- df.ctrb
df.ctrn$turb.id <- 3

opt.cov = c('D','density','Vn','hour')
n.rep = 2 # just for illustration; a user may use at leat 10 for this.

res <- bootstrap.gain(df.ref, df.ctrb, df.ctrn, opt.cov = opt.cov, n.rep = n.rep,
 p1.beg = '2014-10-24', p1.end = '2014-10-25', p2.beg = '2014-10-25',
 p2.end = '2014-10-26', ratedPW = 1000, AEP = 300000, pw.freq = pw.freq,
 k.fold = 2)

length(res) #2
sapply(res, function(ls) ls$gain.res$gainCurve) #This provides 2 gain curves.
sapply(res, function(ls) ls$gain.res$gain) #This provides 2 gain values.

}
\references{
H. Hwangbo, Y. Ding, and D. Cabezon, 'Machine Learning Based
  Analysis and Quantification of Potential Power Gain from Passive Device
  Installation,' arXiv:1906.05776 [stat.AP], Jun. 2019.
  \url{https://arxiv.org/abs/1906.05776}.
}
