% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chebvand.R
\name{chebvand}
\alias{chebvand}
\title{Creating Vandermonde-like matrix for the Chebyshev polynomials}
\usage{
chebvand(p, m = NULL)
}
\arguments{
\item{p}{points to evaluate. If a scalar, then \code{p} equally spaced points
on \code{[0,1]} are used.}

\item{m}{number of rows of the matrix. \code{chebvand(p, m)} is the rectangular version of
\code{chebvand(p)} with \code{m} rows.}
}
\value{
Vandermonde-like matrix for the Chebyshev polynomials
}
\description{
Produces the (primal) Chebyshev Vandermonde matrix based on
  the points \code{p}. \code{C[i,j] = T_{i-1}p[j]}, where \code{T_{i-1}} is the Chebyshev
  polynomial of degree \code{i-1}
}
