% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.valuemap.R
\name{gbm.valuemap}
\alias{gbm.valuemap}
\title{Decision Support Tool that generates (Marine) Protected Area options using
species predicted abundance maps}
\usage{
gbm.valuemap(
  dbase,
  loncolno = 1,
  latcolno = 2,
  goodcols,
  badcols,
  conservecol = NULL,
  plotthis = c("good", "bad", "both", "close"),
  maploops = c("Combo", "Biomass", "Effort", "Conservation"),
  savedir = tempdir(),
  savethis = TRUE,
  HRMSY = 0.15,
  goodweight = NULL,
  badweight = NULL,
  m = 1,
  alerts = TRUE,
  BnW = TRUE,
  shape = NULL,
  pngtype = c("cairo-png", "quartz", "Xlib"),
  byxport = NULL,
  ...
)
}
\arguments{
\item{dbase}{Data.frame to load. Expects Lon, Lat & data columns: predicted
abundances, fishing effort etc. E.g.: Abundance_Preds_All.csv from gbm.auto.}

\item{loncolno}{Column number in dbase which has longitudes.}

\item{latcolno}{Column number in dbase which has latitudes.}

\item{goodcols}{Which column numbers are abundances (where higher = better)?
List them in order of highest conservation importance first e.g. c(3,1,2,4).
Either numeric column number or quoted character column name.}

\item{badcols}{Which col no.s are 'negative' e.g. fishing (where higher =
worse)? Either numeric column number or quoted character column name.}

\item{conservecol}{Conservation column, from gbm.cons.}

\item{plotthis}{Vector of variable types to plot. Delete any,or all w/ NULL.}

\item{maploops}{Vector of sort loops to run. See Dedman et al 2017 "Towards a
flexible Decision Support Tool for MSY-based Marine Protected Area design
for skates and rays";
https://academic.oup.com/icesjms/article/74/2/576/2669563 . All 4 options
create a total MPA which conserves Bpa, but in different ways: Biomass
closes areas of high biomass first. Effort closes areas of high fisheries
area last. Combo strikes a balance between the two, and you can change the
default 1:1 balance with goodweight and badweight parameters. Conservation
uses the output of gbm.cons to prioritise closure of areas of high
conservation value, which may not be identical to areas of highest biomass.}

\item{savedir}{Save outputs to a temporary directory (default) else change to
current directory e.g. "/home/me/folder". Do not use getwd() here.}

\item{savethis}{Export all data as csv?}

\item{HRMSY}{Maximum percent of each goodcols stock which can be removed
yearly, as decimal (0.15 = 15 pct). Must protect remainder: 1-HRMSY. Single
number or vector. If vector, same order as goodcols. Required.}

\item{goodweight}{Single/vector weighting multiple(s) for goodcols array.}

\item{badweight}{Ditto for badcols array.}

\item{m}{Multiplication factor for Bpa units. 1000 to convert tonnes to
kilos, 0.001 kilos to tonnes. Assumedly the same for all goodcols.}

\item{alerts}{Play sounds to mark progress steps.}

\item{BnW}{Also produce greyscale images for print publications.}

\item{shape}{Set coastline shapefile, else uses British Isles. Generate your
own with gbm.basemap.}

\item{pngtype}{File-type for png files, alternatively try "quartz" on Mac.
Choose one.}

\item{byxport}{Dummy param for package testing for CRAN, ignore.}

\item{...}{Optional terms for gbm.map.}
}
\value{
Species abundance, abundance vs avoid variable, and MPA maps per
species and sort type, in b&w if set. CSVs of all maps if set.
}
\description{
Scales response variable data, maps a user-defined explanatory variable to be
avoided, e.g. fishing effort, combines them into a map showing areas to
preferentially close. Bpa, the precautionary biomass required to protect the
spawning stock, is used to calculate MPA size. MPA is then grown to add
subsequent species starting from the most conservationally at-risk species,
resulting in one MPA map per species, and a multicolour MPA map of all.
All maps list the percentage of the avoid-variables total that is overlapped
by the MPA in the map legend.
}
\details{
Bpa is the volume of biomass under the 2D abundance surface e.g. predabund
from gbm.auto. B (biomass), * HRMSY (Fmsy proportion) = Bpa. You may be able
to get Fmsy from stock asssessments etc.
maploops: explain concept of biomass vs effort, combo in the middle (default
weighting 1:1 can change with good/badweight), and Conservation from gbm.cons.
}
\author{
Simon Dedman, \email{simondedman@gmail.com}
}
