% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbp4d_cpp_rd.r
\docType{class}
\name{gbp4d}
\alias{Rcpp_gbp4d}
\alias{Rcpp_gbp4d-class}
\alias{gbp4d}
\title{gbp4d}
\format{An object of class \code{C++Class} of length 1.}
\usage{
gbp4d
}
\description{
generalized bin packing problem in 4 dimension, a.k.a bin packing problem with weight limit.
}
\details{
gbp4d init a profit vector p, a length l, a depth d, a height h, and a weight w, along with
  associate constraints ml, md, mh and mw.
 gbp4d should fit it (l, d, h, w) into bn (ml, md, mh, mw) with w on weight limit constraint
  and l, d, h on geometry intepretation.
 gbp4d solver would solve

   maximize   sum_{j=1}^{n} p_{j} k_{j}

   subject to sum_{j=1}^{n} w_{j} k_{j} leq mw and

              fit (l_{j}, d_{j}, h_{j}) at coordinate (x_{j}, y_{j}, z_{j})
              such that no overlap in ml x md x mh cuboid, j = 1, ......, n

 and instantiate a gbp4d object with a x-axis coordinate vector x, a y-axis coordinate vector y,
  a z-axis coordinate vector z, a selection vector k, and an objective o.

 a gbp4d class instance has 6 fields:

  - p: profit of it fit into bn <vector>

       created via cluster w via gbp1d, cluster max(l, d, h) and area via gbp4d_solver_dpp_main_create_p()

  - it: it position and scale <matrix>

    - x, y, z, w it position and w in the bin <numeric> (w hold in bn when fit it in bn)

    - l, d, h, w it scale along x, y, z and w <numeric> (w of it itself)

  - bn: bn scale <vector>

    - l, d, h, w bn scale along x, y, z and w <numeric>

  - k: selection indicator 0, 1 <vector>

  - o: objective achivement volumn fit in over volumn overall <numeric>

  - ok: a quick indicator of all it fit into bn? <bool>
}
\note{
p is a proxy of ranking on cuboid fit difficulty, often a func of max(l, d, h), surface, volume
  and solver would often maximize sum_{j=1}^{n} v_{j} k_{j} instead of sum_{j=1}^{n} p_{j} k_{j}
}
\seealso{
Other gbp4d: \code{\link{gbp4d_checkr}},
  \code{\link{gbp4d_solver_dpp}}
}
\keyword{datasets}

