% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice_space}
\alias{slice_space}
\title{Extract a single time series (spatial slice) from a data cube}
\usage{
slice_space(cube, loc = NULL, i = NULL)
}
\arguments{
\item{cube}{source data cube}

\item{loc}{numeric length-two vector; spatial coordinates (x, y) of the time series, expressed in the coordinate reference system of the source data cube}

\item{i}{integer length-2 vector; indexes (x,y) of the time slice (zero-based)}
}
\description{
Create a proxy data cube, which extracts a time series from a data cube defined by spatial coordinates or integer x and y indexes.
}
\details{
Either \code{loc} or \code{i} must be non-NULL. If both arguments are provided, integer indexes \code{i} are ignored.
}
\note{
This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db"), quiet = TRUE) 
}
L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P3M", aggregation = "median")
L8.cube = raster_cube(L8.col, v, mask=image_mask("BQA", bits=4, values=16))
L8.rgb = select_bands(L8.cube, c("B02", "B03", "B04"))
L8.ts = slice_space(L8.rgb, loc = c(5e05, 4400000))
L8.ts

\donttest{
plot(L8.ts, join.timeseries = TRUE)
}

}
