% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readgdx}
\alias{readgdx}
\title{readgdx}
\usage{
readgdx(fname, varname, field = NULL)
}
\arguments{
\item{fname}{the gdx filename.}

\item{varname}{name of the object to load.}

\item{field}{(for variable), select a field (default="l").}
}
\value{
a data.table
}
\description{
Read a variable, parameter or set from a gdx file to a data.table.
}
\examples{
\dontrun{
dt <- as.data.table(mtcars, keep.rownames = TRUE)
tmpgdx <- file.path(tempdir(), "test.gdx")
test_var <- "mtcars"
writegdx(tmpgdx, dt, test_var, valcol="wt", uelcols="rn", type="parameter")
new_dt <- readgdx(tmpgdx, test_var)
}
}
