% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodist.R
\name{geodist}
\alias{geodist}
\title{Compute distance for geographic coordinates}
\usage{
geodist(coords1, coords2, longlat = FALSE)
}
\arguments{
\item{coords1}{A two-dimensional matrix of coordinates.}

\item{coords2}{A two-dimensional matrix of coordinates.}

\item{longlat}{A logical value indicating whether
Euclidean distance (\code{longlat = FALSE}) or great
circle distance (\code{longlat = FALSE}) should be
computed. The default is \code{longlat = FALSE}.}
}
\value{
A matrix of distances
}
\description{
\code{geodist} computes the distance between the
coordinates in \code{coords1} and \code{coords2}. If
\code{coords2} isn't supplied, then the distances are
computed between the coordinates in \code{coords1} alone.
Otherwise, the pairwise distances between then points in
\code{coords1} and \code{coords2} is computed. If
\code{longlat = TRUE}, then the great circle distance is
computed.
}
\details{
The algorithm used when \code{longlat = TRUE} is a C++
port of the C code written by Roger Bivand for
\code{\link[sp]{spDists}}, which appears to be based on a
special case of the Vincenty formula with a slight
correction based on the WGS84 flattening constant. See
\url{https://en.wikipedia.org/wiki/Great-circle_distance}.
}
\examples{
coords = matrix(runif(10), ncol = 2)
d = geodist(coords)
all.equal(d, as.matrix(dist(coords)), check.attributes = FALSE)
}
