% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesys.R
\name{list_institutes}
\alias{list_institutes}
\title{List FAO WIEWS institutes.}
\usage{
list_institutes(filters = list(), at.least = NULL)
}
\arguments{
\item{filters}{an R \code{structure} with Institute filters}

\item{at.least}{stop fetching when at.least records are received from Genesys}
}
\value{
List of institutes
}
\description{
Institute filters:
- code: list of WIEWS institute codes
- accessions: boolean, TRUE list only institutes with accessions in Genesys, FALSE without accessions
- country$code3: list of ISO3166 country codes
}
\examples{
\dontrun{
  # Retrieve taxa of selected accessions
  filters <- c();
  filters$accessions = TRUE; # Has accessions in Genesys
  institutes <- genesysr::list_institutes(filters)
}

}
\seealso{
\code{\link{mcpd_filter}}
}
