% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtrfn.R
\name{rtrfn}
\alias{rtrfn}
\title{A generating function of trapezoidal fuzzy number via uniform distribution}
\usage{
rtrfn(n, a, c, r, b)
}
\arguments{
\item{n}{total number of random trapezoidal fuzzy number}

\item{a}{the left point of trapezoidal fuzzy number}

\item{c}{the left-middle point of trapezoidal fuzzy number}

\item{r}{the right-middle point of trapezoidal fuzzy number}

\item{b}{the right point of trapezoidal fuzzy number}
}
\value{
A data frame with two variables, that is, x and mf
}
\description{
A generating function of trapezoidal fuzzy number via uniform distribution based on Souliotis et al. (2022). See detail in references.
}
\note{
In general, \code{a}< \code{c}< \code{r} < \code{b} for generating a trapezoidal fuzzy random number.
If \code{a}=\code{c}=\code{r}=\code{b}, it will produce a crisp number.
If \code{a}<\code{c}=\code{r}<\code{b}, it will produce a triangular fuzzy random number.
}
\examples{
df2<- rtrfn(500,1,3,4,6)
head(df2)
plot(df2)  # or plot(df2,type='h')
}
\references{
Souliotis, G., Alanazi, Y., & Papadopoulos, B. (2022). Construction of fuzzy numbers via cumulative distribution function. Mathematics, 10(18), 3350. https://doi.org/10.3390/math10183350
}
