% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synapse_authentication.R
\name{check_genie_access}
\alias{check_genie_access}
\title{Check Access to GENIE Data}
\usage{
check_genie_access(
  username = NULL,
  password = NULL,
  pat = NULL,
  check_consortium_access = FALSE
)
}
\arguments{
\item{username}{'Synapse' username. If NULL, package will search package
environment for "username".}

\item{password}{'Synapse' password. If NULL, package will search package
environment for "password".}

\item{pat}{'Synapse' Personal Access Token. If NULL, package will search package
environment for "pat".}

\item{check_consortium_access}{Specifies whether access to GENIE BPC consortium
data releases (vs. public data releases) is checked. Default is FALSE,
indicating that access to GENIE BPC public data releases is checked instead.}
}
\value{
A success message if you are able to access GENIE BPC data; otherwise
  an error
}
\description{
Check Access to GENIE Data
}
\examples{
\dontrun{
# if credentials are saved:
check_genie_access()
}
}
\author{
Karissa Whiting
}
