% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_gen.R
\name{random_init_polynomial}
\alias{random_init_polynomial}
\title{Randomly generate an initial point in the domain defined by a single polynomial with no negative coefficient.}
\usage{
random_init_polynomial(domain)
}
\arguments{
\item{domain}{A list returned from \code{make_domain()} that represents the domain. Currently only supports \code{domain$type == "polynomial" && length(domain$ineqs) == 1}. If \code{domain$ineqs[[1]]$uniform == FALSE}, \code{domain$ineqs[[1]]$coeffs} must not contain negative numbers.}
}
\value{
A \code{p} vector inside the domain defined by \code{domain}.
}
\description{
Randomly generate an initial point in the domain defined by a single polynomial with no negative coefficient.
}
\details{
If inequality is uniform, find the uniform bound for each component and generate each coordinate using \code{random_init_uniform()}.
Otherwise, first randomly generate centered laplace variables for components with coefficient 0 (free variables).
Then assign a \code{quota} of \code{eq$const / length(nonzero_coefficient)} to each coordinate (so that each \cr
   \code{frac_pow(x[i], eq$power_numers[i], eq$power_denoms[i], eq$abs) * eq$coeffs[i]} is compared to \code{quota}).
Deal with components with \code{exp()} term first, and generate each coordinate while fulfilling \code{quota} if possible; if not, randomly generate from \cr
   \code{[-0.01,0.01]/abs(eq$power_numers[i])}.
Then recalculate the new \code{quota} which subtracts the exp() terms from \code{eq$const}, and this time divided by the number of remaining components.
If \code{quota} becomes negative and \code{eq$larger == FALSE}, each component, after \code{frac_pow()} is assumed to give a negative number.
This is not possible if the term has the form x^\{even_number/even_number\}, or if the term is not log() in the case where \code{eq$nonnegative == TRUE || eq$abs == TRUE}.
Change quota to a positive smaller in absolute value for these bad terms and generate.
Finally, recalculate quota as before and generate the rest of the "good" components.

In some extreme domains the function may fail to generate a point within the domain.
Also, it is not guaranteed that the function returns a point in an area with a high probability density.
}
\examples{
p <- 30
poly_d <- function(ex, abs, nng){
   return (make_domain("polynomial", p=p, 
                       ineqs=list(list(expression=ex, abs=abs, nonnegative=nng))))
}

random_init_polynomial(poly_d(paste("sum(exp(x))<=", p*1.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("sum(exp(x))<=", p*1.01), abs=FALSE, nng=FALSE))
random_init_polynomial(poly_d(paste("sum(exp(x))>", p*1.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("sum(exp(x))>", p*1.01), abs=TRUE, nng=FALSE))
random_init_polynomial(poly_d(paste("sum(log(x))<=", 0.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("sum(log(x))>", 0.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("sum(x^2)<=", 0.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("sum(x^2)>", 0.01), abs=TRUE, nng=TRUE))

random_init_polynomial(poly_d(paste("exp(x)<=", 1.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("exp(x)<=", 1.01), abs=FALSE, nng=FALSE))
random_init_polynomial(poly_d(paste("exp(x)>", 1.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("exp(x)>", 1.01), abs=TRUE, nng=FALSE))
random_init_polynomial(poly_d(paste("log(x)<=", 0.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("log(x)>", 0.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("x^2<=", 0.01), abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(paste("x^2>", 0.01), abs=TRUE, nng=TRUE))

random_init_polynomial(poly_d("x1^2+x2^2+log(x3)<-2", abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d("x1^2+x2^2+log(x3)>-2", abs=FALSE, nng=FALSE))
random_init_polynomial(poly_d("x1^(3/5)+x2^2+x3^(1/3)<-2", abs=FALSE, nng=FALSE))
random_init_polynomial(poly_d("x1^(3/5)+x2^2+x3^(1/3)>-2", abs=FALSE, nng=FALSE))
random_init_polynomial(poly_d("x1^(3/5)+1.2*exp(2*x2)+2.3*exp(-3*x3)<-2", abs=FALSE, nng=FALSE))
random_init_polynomial(poly_d("x1^(3/5)+1.2*exp(2*x2)+2.3*exp(-3*x3)<2", abs=TRUE, nng=FALSE))
random_init_polynomial(poly_d("x1^(3/5)+1.2*exp(2*x2)+2.3*exp(-3*x3)>-2", abs=TRUE, nng=FALSE))
random_init_polynomial(poly_d("x1^(3/5)+2.3*log(x4)+1.3*exp(2*x2)+0.7*exp(-3*x3)<-2", 
                       abs=TRUE, nng=FALSE))
random_init_polynomial(poly_d("x1^(3/5)+2.3*log(x4)+1.3*exp(2*x2)+0.7*exp(-3*x3)>-2", 
                       abs=FALSE, nng=FALSE))
random_init_polynomial(poly_d(
   "x1^(3/5)+0.9*x2^(2/3)+2.7*x3^(-3/2)+1.1*x4^(-5)+1.1*exp(2x5)+1.3*exp(-3x6)+0.7*log(x7)<-2", 
                       abs=TRUE, nng=FALSE))
random_init_polynomial(poly_d(
   "x1^(3/5)+0.9*x2^(2/3)+2.7*x3^(-3/2)+1.1*x4^(-5)+1.1*exp(2x5)+1.3*exp(-3x6)+0.7*log(x7)<-2", 
                       abs=FALSE, nng=TRUE))
random_init_polynomial(poly_d(
   "x1^(3/5)+0.9*x2^(2/3)+2.7*x3^(-3/2)+1.1*x4^(-5)+1.1*exp(2x5)+1.3*exp(-3x6)+0.7*log(x7)>-2", 
                       abs=TRUE, nng=FALSE))
random_init_polynomial(poly_d(
   "x1^(3/5)+0.9*x2^(2/3)+2.7*x3^(-3/2)+1.1*x4^(-5)+1.1*exp(2x5)+1.3*exp(-3x6)+0.7*log(x7)>2", 
                       abs=TRUE, nng=TRUE))
random_init_polynomial(poly_d(
   "x1^(3/5)+0.9*x2^(2/3)+2.7*x3^(-3/2)+1.1*x4^(-5)+1.1*exp(2x5)+1.3*exp(-3x6)+0.7*log(x7)>2", 
                       abs=FALSE, nng=FALSE))
}
