% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_evaluation.R
\name{calcDaviesBouldin}
\alias{calcDaviesBouldin}
\title{Davies-Bouldin index}
\usage{
calcDaviesBouldin(data, belongmatrix, centers)
}
\arguments{
\item{data}{The original dataframe used for the clustering (n*p)}

\item{belongmatrix}{A membership matrix (n*k)}

\item{centers}{The centres of the clusters}
}
\value{
A float: the Davies-Bouldin index
}
\description{
Calculate the Davies-Bouldin index of clustering quality.
}
\details{
The Davies-Bouldin index \insertCite{da2020incremental}{geocmeans} can be seen as the ratio of the within cluster dispersion and the
between cluster separation. A lower value indicates a higher cluster compacity
or a higher cluster separation. The formula is:

\deqn{DB = \frac{1}{k}\sum_{i=1}^k{R_{i}}}

with:

\deqn{R_{i} =\max_{i \neq j}\left(\frac{S_{i}+S_{j}}{M_{i, j}}\right)}
\deqn{S_{l} =\left[\frac{1}{n_{l}} \sum_{l=1}^{n}\left\|\boldsymbol{x_{l}}-\boldsymbol{c_{i}}\right\|*u_{i}\right]^{\frac{1}{2}}}
\deqn{M_{i, j} =\sum\left\|\boldsymbol{c}_{i}-\boldsymbol{c}_{j}\right\|}

So, the value of the index is an average of \eqn{R_{i}} values. For each cluster, they represent
its worst comparison with all the other clusters, calculated
as the ratio between the compactness of the two clusters and the separation
of the two clusters.
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
calcDaviesBouldin(result$Data, result$Belongings, result$Centers)
}
\references{
\insertAllCited{}
}
