% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{Mode}
\alias{Mode}
\title{get the mode of a dataset}
\usage{
Mode(x, categorical = FALSE)
}
\arguments{
\item{x}{a vector}

\item{categorical}{logical. If \code{TRUE}, returns the most
frequently occuring value for categorical variables. If
\code{FALSE}, returns the value corresponding to the maximimum
kernel density for continuous variables}
}
\value{
a scalar
}
\description{
Computes the most frequently occuring value in a
    sampling distribution.
}
\examples{
data(catchments,package='geostats')
m1 <- Mode(catchments$CaMg,categorical=TRUE)

m2 <- 1:50
for (i in m2){
   m2[i] <- Mode(rnorm(100),categorical=FALSE)
}
hist(m2)
}
