% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna_tools.R
\name{convert_sequence_to_numbers}
\alias{convert_sequence_to_numbers}
\title{Map a sequence to a vector of numbers (generic \code{ggDNAvis} helper)}
\usage{
convert_sequence_to_numbers(sequence, length = NA)
}
\arguments{
\item{sequence}{\code{character}. A DNA/RNA sequence (\code{A/C/G/T/U}) to be encoded numerically. No other characters allowed. Only one sequence allowed.}

\item{length}{\code{integer}. How long the output numerical vector should be. If shorter than the sequence, the vector will include the first \emph{n} bases up to this length. If longer than the sequence, the vector will be padded with 0s at the end. If left blank/set to \code{NA} (default), will output a vector the same length as the input sequence.}
}
\value{
\verb{integer vector}. The numerical encoding of the input sequence, cut/padded to the desired length.
}
\description{
This function takes a sequence and encodes it as a vector
of numbers for visualisation via \code{\link[=rasterise_matrix]{rasterise_matrix()}}. \cr\cr
Encoding: \code{A = 1}, \code{C = 2}, \code{G = 3}, \code{T/U = 4}.
}
\examples{
convert_sequence_to_numbers("ATCGATCG")
convert_sequence_to_numbers("ATCGATCG", length = NA)
convert_sequence_to_numbers("ATCGATCG", length = 4)
convert_sequence_to_numbers("ATCGATCG", length = 10)

}
