% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_arrow.R
\name{annotate_arrow}
\alias{annotate_arrow}
\title{Arrow annotation layer}
\usage{
annotate_arrow(
  geom = "arrow",
  x = NULL,
  y = NULL,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  xend = NULL,
  yend = NULL,
  ...,
  na.rm = FALSE
)
}
\arguments{
\item{geom}{name of geom to use for annotation}

\item{x, y, xmin, ymin, xmax, ymax, xend, yend}{Positioning aesthetics. At least
one of these must be specified.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}
}
\value{
A \verb{<Layer>} ggproto object that can be added to a plot.
}
\description{
This function mirrors \code{\link[ggplot2:annotate]{annotate()}} with the following
changes. First, the \code{geom} argument is pre-populated with \code{"arrow"}. Second,
several parameters from ggarrow are special-cased, because no warning needs
to be issued when they don't have length 1.
}
\examples{
# Annotate an arrow
ggplot() +
  annotate_arrow(
    x = c(0, 1), y = c(0, 1),
    arrow_head = arrow_head_line(),
    arrow_fins = arrow_fins_line(),
    length_head = unit(5, "mm"),
    length_fins = unit(5, "mm")
  )

# Still works with other geoms as well
ggplot(mtcars, aes(x = wt, y = mpg)) + geom_point() +
  annotate_arrow("text", x = 4, y = 25, label = "Some text")
}
\seealso{
Other arrow geoms: 
\code{\link{geom_arrow}()},
\code{\link{geom_arrow_chain}()},
\code{\link{geom_arrow_curve}()},
\code{\link{geom_arrow_segment}()}
}
\concept{arrow geoms}
