% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecp.R
\name{ecp_wrapper}
\alias{ecp_wrapper}
\title{ecp wrapper}
\usage{
ecp_wrapper(data, algorithm = "divisive", min_size = 2, ...)
}
\arguments{
\item{data}{A vector.}

\item{algorithm}{Either \code{divisive} or \code{agglo}. \code{divisive} is
the default.}

\item{min_size}{Minimum number of observations between change points. By
default is 2. This argument is only applied when \code{algorithm =
"divisive"}.}

\item{...}{Extra arguments to pass on either from \code{e.divisive()} or
\code{e.agglo()}.}
}
\value{
A tibble includes which point(s) is/are the changepoint along with
  raw changepoint value corresponding to that changepoint.
}
\description{
The ecp package provides a non-parametric way to detect changepoints. Unlike
the changepoint package, it does not assume raw data to have any formal
distribution. This wrapper function wraps two functions from the ecp package,
i.e., \code{e.divisive()} and \code{e.agglo()}. Users can use either function
by switching the \code{algorithm} argument. Before using the wrapper function
, seed should be set for the sake of reproducibility.
}
\examples{
set.seed(2022)
ecp_wrapper(c(rnorm(100,0,1),rnorm(100,0,10)))
ecp_wrapper(c(rnorm(100,0,1),rnorm(100,10,1)))

}
\references{
\insertRef{james2013ecp}{ggchangepoint}
}
