% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{ggcptplot}
\alias{ggcptplot}
\title{Plot for the changepoint package}
\usage{
ggcptplot(
  data,
  change_in = "mean_var",
  cp_method = "PELT",
  ...,
  cptline_alpha = 1,
  cptline_color = "blue",
  cptline_type = "solid",
  cptline_size = 0.5
)
}
\arguments{
\item{data}{A vector.}

\item{change_in}{Choice of \code{mean_var}, \code{mean}, \code{var}, and
\code{cpt_np}. Each choice corresponds to \code{cpt.meanvar()},
\code{cpt.mean()}, \code{cpt.var()} and \code{cpt.np()} respectively. The
default is \code{mean_var}.}

\item{cp_method}{A wide range of choices (i.e., \code{AMOC}, \code{PELT},
\code{SegNeigh} or \code{BinSeg}). Please note when \code{change_in} is
\code{cpt_np}, \code{PELT} is the only option.}

\item{...}{Extra arguments for each \code{cpt} function mentioned in the
\code{change_in} section.}

\item{cptline_alpha}{The value of alpha for the vertical changepoint line(s),
default is 1, meaning no transparency.}

\item{cptline_color}{The color for the vertical changepoint line(s), default
is \code{blue}.}

\item{cptline_type}{The linetype for the vertical changepoint line(s),
default is \code{solid}.}

\item{cptline_size}{The size for the vertical changepoint line(s), default is
\code{0.5}.}
}
\value{
A line plot with data points along with the vertical lines
  representing changepoints.
}
\description{
The plot for changepoints detected by the changepoint package is a line plot
for the raw data and the vertical lines representing each changepoint. The
x-axis is the row number of the raw data in the original data vector. The
plot inherits ggplot2, meaning users can add ggplot2 functions on top the
changepoint plot for customization.
}
\examples{
ggcptplot(c(rnorm(100,0,1),rnorm(100,0,10)))
ggcptplot(c(rnorm(100,0,1),rnorm(100,10,1)))

}
