% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecp.R
\name{ggecpplot}
\alias{ggecpplot}
\title{Plot for the ecp package}
\usage{
ggecpplot(
  data,
  algorithm = "divisive",
  min_size = 2,
  ...,
  cptline_alpha = 1,
  cptline_color = "blue",
  cptline_type = "solid",
  cptline_size = 0.5
)
}
\arguments{
\item{data}{A vector.}

\item{algorithm}{Either \code{divisive} or \code{agglo}. \code{divisive} is
the default.}

\item{min_size}{Minimum number of observations between change points. By
default is 2. This argument is only applied when \code{algorithm =
"divisive"}.}

\item{...}{Extra arguments to pass on either from \code{e.divisive()} or
\code{e.agglo()}.}

\item{cptline_alpha}{The value of alpha for the vertical changepoint line(s),
default is 1, meaning no transparency.}

\item{cptline_color}{The color for the vertical changepoint line(s), default
is \code{blue}.}

\item{cptline_type}{The linetype for the vertical changepoint line(s),
default is \code{solid}.}

\item{cptline_size}{The size for the vertical changepoint line(s), default is
\code{0.5}.}
}
\value{
A line plot with data points along with the vertical lines
  representing changepoints.
}
\description{
The plot for changepoints detected by the ecp package is a line plot for the
raw data and the vertical lines representing each changepoint. The x-axis is
the row number of the raw data in the original data vector. The plot inherits
ggplot2, meaning users can add ggplot2 functions on top the changepoint plot
for customization.
}
\examples{
ggecpplot(c(rnorm(100,0,1),rnorm(100,0,10)))
ggecpplot(c(rnorm(100,0,1),rnorm(100,0,10)))
}
