% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_feature_label.R
\name{geom_feature_label}
\alias{geom_feature_label}
\title{A 'ggplot2' geom to add text labels to point genetic features}
\usage{
geom_feature_label(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE,
  feature_height = unit(4, "mm"),
  label_height = unit(3, "mm"),
  ...
)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{As
standard for ggplot2. inherit.aes is set to FALSE by default, as features
are not likely to share any plot aesthetics other than y.}

\item{feature_height}{\code{grid::unit()} object giving the height of the feature
being labelled, and hence the distance of the label above or below the
molecule line. Can be set as a negative value for features drawn below the
line. Defaults to 4 mm, to align labels with the default height of
\code{geom_feature()}.}

\item{label_height}{\code{grid::unit()} object giving the height of the label
text. Defaults to 3 mm.}
}
\description{
\code{geom_feature_label()} adds text labels to features drawn with
\code{geom_feature}().
}
\details{
Standard 'ggplot2' aesthetics for text are supported (see Aesthetics).
}
\section{Aesthetics}{

\itemize{
\item x (required; position of the feature)
\item y (required; molecule)
\item label (required; the label text)
\item forward (optional; will draw text in the appropriate location for features
with angled arrowheads)
\item colour
\item size
\item alpha
\item family
\item fontface
\item angle
}
}

\examples{

ggplot2::ggplot(example_genes, ggplot2::aes(xmin = start, xmax = end,
                                            y = molecule, fill = gene)) +
  geom_gene_arrow() +
  geom_feature(data = example_features, ggplot2::aes(x = position, y = molecule, 
                                                     forward = forward)) +
  geom_feature_label(data = example_features,
                     ggplot2::aes(x = position, y = molecule, label = name, 
                                  forward = forward)) + 
  ggplot2::facet_wrap(~ molecule, scales = "free")

}
\seealso{
\code{\link[=geom_feature]{geom_feature()}}
}
