% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_alitv.R
\name{read_alitv}
\alias{read_alitv}
\title{Read AliTV .json file}
\usage{
read_alitv(file)
}
\arguments{
\item{file}{path to json}
}
\value{
list with seqs, genes, and links
}
\description{
this file contains sequences, links and (optionally) genes
}
\examples{
ali <- read_alitv("https://alitvteam.github.io/AliTV/d3/data/chloroplasts.json")
gggenomes(ali$genes, ali$seqs, links = ali$links) +
  geom_seq() +
  geom_bin_label() +
  geom_gene(aes(fill = class)) +
  geom_link()
p <- gggenomes(ali$genes, ali$seqs, links = ali$links) +
  geom_seq() +
  geom_bin_label() +
  geom_gene(aes(color = class)) +
  geom_link(aes(fill = identity)) +
  scale_fill_distiller(palette = "RdYlGn", direction = 1)
p \%>\%
  flip_seqs(5) \%>\%
  pick_seqs(1, 3, 2, 4, 5, 6, 7, 8)
}
