% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpicrust2_extended.R
\name{ggpicrust2_extended}
\alias{ggpicrust2_extended}
\title{Integrated analysis with ggpicrust2 including GSEA}
\usage{
ggpicrust2_extended(..., run_gsea = FALSE, gsea_params = list())
}
\arguments{
\item{...}{Parameters passed to ggpicrust2()}

\item{run_gsea}{Logical value indicating whether to perform GSEA analysis}

\item{gsea_params}{List of parameters to pass to pathway_gsea()}
}
\value{
A list containing ggpicrust2 and GSEA results
}
\description{
This function extends the ggpicrust2 functionality to include Gene Set Enrichment Analysis (GSEA).
}
\examples{
\dontrun{
# Load example data
data(ko_abundance)
data(metadata)

# Run integrated analysis
integrated_results <- ggpicrust2_extended(
  data = ko_abundance,
  metadata = metadata,
  group = "Environment",
  pathway = "KO",
  daa_method = "LinDA",
  ko_to_kegg = TRUE,
  run_gsea = TRUE,
  gsea_params = list(
    method = "fgsea",
    rank_method = "signal2noise",
    nperm = 1000
  )
)

# Access DAA results
daa_results <- integrated_results$daa_results

# Access GSEA results
gsea_results <- integrated_results$gsea_results

# Access plots
daa_plot <- integrated_results$daa_plot
gsea_plot <- integrated_results$gsea_plot
}
}
