% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{ggsave}
\alias{ggsave}
\title{Save a ggplot (or other grid object) with sensible defaults}
\usage{
ggsave(
  filename,
  plot = get_last_plot(),
  device = NULL,
  path = NULL,
  scale = 1,
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300,
  limitsize = TRUE,
  bg = NULL,
  create.dir = FALSE,
  ...
)
}
\arguments{
\item{filename}{File name to create on disk.}

\item{plot}{Plot to save, defaults to last plot displayed.}

\item{device}{Device to use. Can either be a device function
(e.g. \link{png}), or one of "eps", "ps", "tex" (pictex),
"pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only). If
\code{NULL} (default), the device is guessed based on the \code{filename} extension.}

\item{path}{Path of the directory to save plot to: \code{path} and \code{filename}
are combined to create the fully qualified file name. Defaults to the
working directory.}

\item{scale}{Multiplicative scaling factor.}

\item{width, height}{Plot size in units expressed by the \code{units} argument.
If not supplied, uses the size of the current graphics device.}

\item{units}{One of the following units in which the \code{width} and \code{height}
arguments are expressed: \code{"in"}, \code{"cm"}, \code{"mm"} or \code{"px"}.}

\item{dpi}{Plot resolution. Also accepts a string input: "retina" (320),
"print" (300), or "screen" (72). Only applies when converting pixel units,
as is typical for raster output types.}

\item{limitsize}{When \code{TRUE} (the default), \code{ggsave()} will not
save images larger than 50x50 inches, to prevent the common error of
specifying dimensions in pixels.}

\item{bg}{Background colour. If \code{NULL}, uses the \code{plot.background} fill value
from the plot theme.}

\item{create.dir}{Whether to create new directories if a non-existing
directory is specified in the \code{filename} or \code{path} (\code{TRUE}) or return an
error (\code{FALSE}, default). If \code{FALSE} and run in an interactive session,
a prompt will appear asking to create a new directory when necessary.}

\item{...}{Other arguments passed on to the graphics device function,
as specified by \code{device}.}
}
\description{
\code{ggsave()} is a convenient function for saving a plot. It defaults to
saving the last plot that you displayed, using the size of the current
graphics device. It also guesses the type of graphics device from the
extension.
}
\details{
Note: Filenames with page numbers can be generated by including a C
integer format expression, such as \verb{\%03d} (as in the default file name
for most R graphics devices, see e.g. \code{\link[=png]{png()}}).
Thus, \code{filename = "figure\%03d.png"} will produce successive filenames
\code{figure001.png}, \code{figure002.png}, \code{figure003.png}, etc. To write a filename
containing the \verb{\%} sign, use \code{\%\%}. For example, \code{filename = "figure-100\%\%.png"}
will produce the filename \verb{figure-100\%.png}.
}
\section{Saving images without ggsave()}{


In most cases \code{ggsave()} is the simplest way to save your plot, but
sometimes you may wish to save the plot by writing directly to a
graphics device. To do this, you can open a regular R graphics
device such as \code{png()} or \code{pdf()}, print the plot, and then close
the device using \code{dev.off()}. This technique is illustrated in the
examples section.
}

\examples{
\dontrun{
ggplot(mtcars, aes(mpg, wt)) +
  geom_point()

# here, the device is inferred from the filename extension
ggsave("mtcars.pdf")
ggsave("mtcars.png")

# setting dimensions of the plot
ggsave("mtcars.pdf", width = 4, height = 4)
ggsave("mtcars.pdf", width = 20, height = 20, units = "cm")

# passing device-specific arguments to '...'
ggsave("mtcars.pdf", colormodel = "cmyk")

# delete files with base::unlink()
unlink("mtcars.pdf")
unlink("mtcars.png")

# specify device when saving to a file with unknown extension
# (for example a server supplied temporary file)
file <- tempfile()
ggsave(file, device = "pdf")
unlink(file)

# save plot to file without using ggsave
p <-
  ggplot(mtcars, aes(mpg, wt)) +
  geom_point()
png("mtcars.png")
print(p)
dev.off()

}
}
\seealso{
The \href{https://ggplot2-book.org/themes#sec-saving}{saving section} of the online ggplot2 book.
}
