% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-catenary.R, R/stat-catenary.R
\name{geom_catenary}
\alias{geom_catenary}
\alias{stat_catenary}
\title{Draw a catenary curve}
\usage{
geom_catenary(
  mapping = NULL,
  data = NULL,
  stat = "catenary",
  position = "identity",
  ...,
  chainLength = NULL,
  show.legend = NA,
  inherit.aes = TRUE,
  na.rm = FALSE
)

stat_catenary(
  mapping = NULL,
  data = NULL,
  geom = "path",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  chainLength = NULL,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{chainLength}{Length of chain between two points.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{geom, stat}{Use to override the default connection between
\code{geom_catenary} and \code{stat_catenary}.}
}
\description{
\code{geom_catenary()} draws a catenary curve which has a U-like shape,
similar in appearance to a parabola, which it is not.
}
\details{
If a flexible chain or rope is loosely hung between two fixed
points, it is a curve called a catenary. Catenary, from Latin word catēna,
means "chain".
}
\section{Aesthetics}{

\code{geom_catenary()} understands the following aesthetics (required
aesthetics are in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item alpha
\item color
\item group
\item linetype
\item linewidth
}
}

\examples{
dat <- data.frame(
  x = c(0, 1, 2),
  y = c(1, 2, -3)
)

p <- ggplot(dat, aes(x, y))
p + geom_catenary() +
  ylim(-4, NA)

# use chainLength argument to change default behaviour
# if you pick a chain length that is too short, a straight line is
# drawn and a message about minimum chain length is shown
p + geom_catenary(chainLength = 10) +
  ylim(-4, NA)

}
