% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_ragged.R, R/facet_ragged_rows.R,
%   R/facet_ragged_cols.R
\name{facet_ragged}
\alias{facet_ragged}
\alias{facet_ragged_rows}
\alias{facet_ragged_cols}
\title{Lay out panels in a ragged grid}
\usage{
facet_ragged_rows(
  rows,
  cols,
  ...,
  scales = "fixed",
  switch = "none",
  strips = "margins",
  axes = "margins",
  align = "start",
  labeller = "label_value"
)

facet_ragged_cols(
  rows,
  cols,
  ...,
  scales = "fixed",
  switch = "none",
  strips = "margins",
  axes = "margins",
  align = "start",
  labeller = "label_value"
)
}
\arguments{
\item{rows, cols}{A set of variables or expressions quoted by \code{\link[ggplot2:vars]{ggplot2::vars()}},
the combinations of which define the panels in the layout.}

\item{...}{Arguments reserved for future use.}

\item{scales}{Determines which panels share axis ranges. By default (\code{"fixed"}),
all panels share the same scales. Use \code{"free_x"} to let x-axes vary, use
\code{"free_y"} to let y-axes vary, or \code{"free"} to let both axes vary. Panels
within groups always share the scale along the grouping dimension.}

\item{switch}{Determines how facet label strips are positioned. By default
(\code{"none"}), strips are drawn to the top and right of the panels. Use \code{"x"}
to switch the top strip to the bottom, use \code{"y"} to switch the right strip
to the left, or \code{"both"} to do both.}

\item{strips}{Determines which facet label strips are drawn. By default
(\code{"margins"}), strips between panels along the grouping dimension will be
suppressed. Use \code{"all"} to always draw both strips.}

\item{axes}{Determines which axes are drawn. By default (\code{"margins"}), axes
between panels will be suppressed if they are fixed. Use \code{"all_x"} to
always draw x-axes, \code{"all_y"} to always draw y-axes, or \code{"all"} to always
draw both axes.}

\item{align}{Determines how panels are positioned within groups. By default
(\code{"start"}), panels in groups are densely packed from the start. Use
\code{"end"} to instead pack panels to the end of the group.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:label_parsed]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:label_value]{label_value()}} is used by default,
check it for more details and pointers to other options.}
}
\value{
A \code{Facet} that can be added to a \code{ggplot}.
}
\description{
These facets create layouts in-between \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} and
\code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}}. Panels are arranged into groups stacked along the
defining dimension, but remain independent in the other dimension, allowing
for a grid with ragged edges. This can be useful, for example, to represent
nested or partially crossed relationships between faceting variables.
}
\examples{
p <- ggplot(mpg, aes(displ, cty)) + geom_point()
p + facet_ragged_rows(vars(drv), vars(cyl))
p + facet_ragged_cols(vars(cyl), vars(drv))
\donttest{
# Allow axes to vary between panels
p + facet_ragged_rows(vars(drv), vars(cyl), scales = "free_y")
p + facet_ragged_rows(vars(drv), vars(cyl), scales = "free")

# Change strip label positions
p + facet_ragged_rows(vars(drv), vars(cyl), switch = "y")
p + facet_ragged_rows(vars(drv), vars(cyl), switch = "both")

# Draw strips between panels
p + facet_ragged_rows(vars(drv), vars(cyl), strips = "all")

# Draw axes between panels
p + facet_ragged_rows(vars(drv), vars(cyl), axes = "all_x")
p + facet_ragged_rows(vars(drv), vars(cyl), axes = "all")
}
# Change panel alignment
p + facet_ragged_rows(vars(drv), vars(cyl), align = "end")
}
