% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_key.r
\name{draw_key_sankeyedge}
\alias{draw_key_sankeyedge}
\alias{draw_key_sankeynode}
\title{Key glyphs for legends}
\usage{
draw_key_sankeyedge(data, params, size)

draw_key_sankeynode(data, params, size)
}
\arguments{
\item{data}{A single row data frame containing the scaled aesthetics to
display in this key}

\item{params}{A list of additional parameters supplied to the geom.}

\item{size}{Width and height of key in mm.}
}
\value{
A grid grob.
}
\description{
Each geom has an associated function that draws the key when the geom needs
to be displayed in a legend. These functions are called \verb{draw_key_*()}, where
\code{*} stands for the name of the respective key glyph. The key glyphs can be
customized for individual geoms by providing a geom with the \code{key_glyph}
argument (see \code{\link[ggplot2:layer]{layer()}} or examples below.)
}
\examples{
## The key glyph for sankey diagrams can be applied to different geoms as well.
## In the example below it is applied to a histogram

library(ggplot2)
ggplot(data.frame(x = rnorm(100), groups = rep(letters[1:2], 2)),
       aes(x = x, fill = groups)) +
  geom_histogram(key_glyph = draw_key_sankeyedge, binwidth = 0.2, alpha = 1)
ggplot(data.frame(x = rnorm(100), groups = rep(letters[1:2], 2)),
       aes(x = x, fill = groups)) +
  geom_histogram(key_glyph = draw_key_sankeynode, binwidth = 0.2)

}
\author{
Pepijn de Vries
}
