% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a-legend-draw.R
\name{draw_key}
\alias{draw_key}
\alias{draw_key_point_trace}
\alias{draw_key_path_trace}
\title{Key glyphs for legends}
\usage{
draw_key_point_trace(data, params, size)

draw_key_path_trace(data, params, size)
}
\arguments{
\item{data}{A single row data frame containing the scaled aesthetics to
display in this key}

\item{params}{A list of additional parameters supplied to the geom.}

\item{size}{Width and height of key in mm.}
}
\value{
A grid grob
}
\description{
Each geom has an associated function that draws the key when the geom needs
to be displayed in a legend. These functions are called \code{draw_key_*()}, where
\code{*} stands for the name of the respective key glyph. The key glyphs can be
customized for individual geoms by providing a geom with the \code{key_glyph}
argument.
}
\examples{
p <- ggplot2::ggplot(stocks, ggplot2::aes(day, value, color = name))

# key glyphs can be specified by their name
p + ggplot2::geom_line(key_glyph = "point_trace")

# key glyphs can be specified via their drawing function
p + ggplot2::geom_line(key_glyph = ggplot2::draw_key_rect)

}
